/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertNull;
import static org.w3c.domts.DOMTest.load;


/**
 * The "getNamespaceURI()" method for an Attribute
 * returns the namespace URI of this node, or null if unspecified.
 * Retrieve the first "emp:address" node which has an attribute of "emp:district"
 * that is specified in the DTD.
 * Invoke the "getNamespaceURI()" method on the attribute.
 * The method should return "http://www.nist.gov".
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSname">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeNSname</a>
 * @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=238">http://www.w3.org/Bugs/Public/show_bug.cgi?id=238</a>
 */
public class namespaceURI01 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", false);
        NodeList elementList = doc.getElementsByTagName("emp:address");
        Element testAddr = (Element) elementList.item(0);
        Attr addrAttr = testAddr.getAttributeNodeNS("http://www.nist.gov", "district");
        assertNull(addrAttr, "Default Attrs not supported");
        // TODO:
        // attrNamespaceURI = addrAttr.getNamespaceURI();
        // assertEquals("namespaceURI", "http://www.nist.gov", attrNamespaceURI);
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namespaceURI01";
    }

}
