/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.portals.gems.util.PrintWriterServletOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBufferedResponse
extends HttpServletResponseWrapper {
    private boolean usingWriter;
    private boolean usingStream;
    protected Logger log = LoggerFactory.getLogger(HttpBufferedResponse.class);
    private ServletOutputStream wrappedStream;
    private PrintWriter writer;

    public HttpBufferedResponse(HttpServletResponse servletResponse, PrintWriter writer) {
        super(servletResponse);
        this.writer = writer;
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getOutputStream can't be used after getWriter was invoked");
        }
        if (this.wrappedStream == null) {
            this.wrappedStream = new PrintWriterServletOutputStream(this.writer, this.getResponse().getCharacterEncoding());
        }
        this.usingStream = true;
        return this.wrappedStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException, IllegalStateException, IOException {
        if (this.usingStream) {
            throw new IllegalStateException("getWriter can't be used after getOutputStream was invoked");
        }
        this.usingWriter = true;
        return this.writer;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }
}

