/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static StringBuffer makeJSONObject(Map objectMap, boolean whenEmptyReturnNewObject) {
        return JSONUtils.makeJSONObject(null, new Map[]{objectMap}, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(Map[] objectMaps, boolean whenEmptyReturnNewObject) {
        return JSONUtils.makeJSONObject(null, objectMaps, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(StringBuffer jsonBuffer, Map objectMap, boolean whenEmptyReturnNewObject) {
        return JSONUtils.makeJSONObject(jsonBuffer, new Map[]{objectMap}, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(StringBuffer jsonBuffer, Map[] objectMaps, boolean whenEmptyReturnNewObject) {
        int objMapsLen;
        if (jsonBuffer == null) {
            jsonBuffer = new StringBuffer();
        }
        int added = 0;
        int n = objMapsLen = objectMaps == null ? 0 : objectMaps.length;
        if (objMapsLen > 0) {
            for (int i = 0; i < objMapsLen; ++i) {
                Map objectMap = objectMaps[i];
                if (objectMap == null || objectMap.size() <= 0) continue;
                if (added == 0) {
                    jsonBuffer.append("{");
                }
                for (Map.Entry objEntry : objectMap.entrySet()) {
                    Object objKey = objEntry.getKey();
                    if (objKey == null) continue;
                    if (added > 0) {
                        jsonBuffer.append(", ");
                    }
                    jsonBuffer.append("\"").append(objKey.toString()).append("\":");
                    Object objVal = objEntry.getValue();
                    if (objVal == null) {
                        objVal = "";
                    }
                    jsonBuffer.append("\"").append(objVal.toString()).append("\"");
                    ++added;
                }
            }
        }
        if (added > 0) {
            jsonBuffer.append("}");
        } else if (whenEmptyReturnNewObject) {
            jsonBuffer.append("{}");
        } else {
            return null;
        }
        return jsonBuffer;
    }

    public static String makeJSONStringArray(Collection stringList) {
        return JSONUtils.makeJSONStringArray(stringList, null);
    }

    public static String makeJSONStringArray(Collection stringList, List compiledUniqueValues) {
        if (stringList != null && stringList.size() > 0) {
            StringBuffer stringListContent = new StringBuffer();
            for (String value : stringList) {
                if (value == null || value.length() <= 0) continue;
                if (stringListContent.length() > 0) {
                    stringListContent.append(", ");
                } else {
                    stringListContent.append("[ ");
                }
                stringListContent.append("\"").append(value).append("\"");
                if (compiledUniqueValues == null || compiledUniqueValues.contains(value)) continue;
                compiledUniqueValues.add(value);
            }
            if (stringListContent.length() > 0) {
                stringListContent.append(" ]");
                return stringListContent.toString();
            }
        }
        return null;
    }

    public static String makeJSONInteger(Object source, boolean quote) {
        String sourceStr;
        String string = sourceStr = source == null ? (String)null : source.toString();
        if (sourceStr != null) {
            try {
                Integer.parseInt(sourceStr);
                if (quote) {
                    sourceStr = "\"" + sourceStr + "\"";
                }
            }
            catch (NumberFormatException nex) {
                sourceStr = null;
            }
        }
        return sourceStr;
    }

    public static String makeJSONBoolean(Object source) {
        String boolStr;
        String string = boolStr = source == null ? (String)null : source.toString();
        if (boolStr != null && !boolStr.equals("false") && !boolStr.equals("true")) {
            boolStr = null;
        }
        return boolStr;
    }
}

