/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.webwidget;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class WebWidgetIFramePortlet
extends GenericVelocityPortlet {
    private static final String DEFAULT_WEB_WIDGET_SOURCE = "<script src=\"http://www.gmodules.com/ig/ifr?url=http://www.google.com/ig/modules/wikipedia.xml&amp;up_mylang=en&amp;synd=open&amp;w=320&amp;h=46&amp;title=Wikipedia&amp;lang=en&amp;country=ALL&amp;border=%23ffffff%7C3px%2C1px+solid+%23999999&amp;output=js\"></script>";
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, String> maxAttributes = new HashMap<String, String>();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.attributes.put("TITLE", "");
        this.attributes.put("ALIGN", "BOTTOM");
        this.attributes.put("CLASS", "");
        this.attributes.put("FRAMEBORDER", "0");
        this.attributes.put("ID", "");
        this.attributes.put("MARGINHEIGHT", "0");
        this.attributes.put("MARGINWIDTH", "0");
        this.attributes.put("NAME", "");
        this.attributes.put("HEIGHT", "");
        this.attributes.put("WIDTH", "100%");
        this.attributes.put("SCROLLING", "NO");
        this.attributes.put("STYLE", "");
        this.attributes.put("WIDGETSOURCE", DEFAULT_WEB_WIDGET_SOURCE);
        this.maxAttributes.put("HEIGHT", "800");
        this.maxAttributes.put("WIDTH", "100%");
        this.maxAttributes.put("SCROLLING", "AUTO");
        this.maxAttributes.put("STYLE", "");
    }

    private String getAttributePreference(PortletPreferences prefs, String attribute) {
        return this.getMappedAttributePreference(prefs, attribute, this.attributes);
    }

    private String getMaxAttributePreference(PortletPreferences prefs, String attribute) {
        return this.getMappedAttributePreference(prefs, "MAX-" + attribute, this.maxAttributes);
    }

    private String getMappedAttributePreference(PortletPreferences prefs, String attribute, Map<String, String> map) {
        return prefs.getValue(attribute, map.get(attribute));
    }

    private void appendAttribute(PortletPreferences prefs, StringBuilder content, String attribute, Map<String, String> map) {
        String value = map == this.maxAttributes ? this.getMaxAttributePreference(prefs, attribute) : this.getAttributePreference(prefs, attribute);
        if (value == null || value.length() == 0) {
            return;
        }
        content.append(" ").append(attribute).append("=\"").append(value).append("\"");
    }

    private void appendAttribute(PortletPreferences prefs, StringBuilder content, String attribute) {
        this.appendAttribute(prefs, content, attribute, this.attributes);
    }

    private void appendMaxAttribute(PortletPreferences prefs, StringBuilder content, String attribute) {
        this.appendAttribute(prefs, content, attribute, this.maxAttributes);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String viewPage = (String)request.getAttribute("ViewPage");
        if (viewPage != null) {
            super.doView(request, response);
        } else {
            this.doIFrame(request, response);
        }
    }

    public void setupPreferencesEdit(RenderRequest request, RenderResponse response) {
        PortletPreferences prefs = request.getPreferences();
        String editablePrefNames = this.getAttributePreference(prefs, "EDITABLEPREFS");
        if (StringUtils.isBlank((String)editablePrefNames)) {
            super.setupPreferencesEdit(request, response);
        } else {
            ArrayList<DefaultMapEntry> prefEntryList = new ArrayList<DefaultMapEntry>();
            HashMap<String, String> prefsMap = new HashMap<String, String>();
            String[] prefNames = StringUtils.split((String)editablePrefNames, (String)",");
            String[] emptyValues = new String[]{};
            for (String prefName : prefNames) {
                String[] prefValues = prefs.getValues(prefName = prefName.trim(), emptyValues);
                prefsMap.put(prefName, prefValues.length == 0 ? "" : prefValues[0]);
                prefEntryList.add(new DefaultMapEntry((Object)prefName, (Object)prefValues));
            }
            this.getContext(request, response).put("prefs", prefEntryList.iterator());
            this.getContext(request, response).put("prefsMap", prefsMap);
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doHelp(request, response);
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doCustom(request, response);
    }

    protected void doIFrame(RenderRequest request, RenderResponse response) throws IOException {
        String trimmedWidgetSource;
        PortletPreferences prefs = request.getPreferences();
        StringBuilder content = new StringBuilder(256);
        content.append("<TABLE CLASS='iframePortletTableContainer' WIDTH='100%'><TBODY CLASS='iframePortletTbodyContainer'><TR><TD>");
        content.append("<IFRAME");
        String source = response.createResourceURL().toString();
        String widgetSource = this.getAttributePreference(request.getPreferences(), "WIDGETSOURCE");
        if (!StringUtils.isBlank((String)widgetSource) && !(trimmedWidgetSource = widgetSource.trim()).startsWith("<")) {
            source = trimmedWidgetSource;
        }
        content.append(" ").append("SRC").append("=\"").append(source).append("\"");
        this.appendAttribute(prefs, content, "ALIGN");
        this.appendAttribute(prefs, content, "CLASS");
        this.appendAttribute(prefs, content, "FRAMEBORDER");
        this.appendAttribute(prefs, content, "ID");
        this.appendAttribute(prefs, content, "MARGINHEIGHT");
        this.appendAttribute(prefs, content, "MARGINWIDTH");
        this.appendAttribute(prefs, content, "NAME");
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            this.appendMaxAttribute(prefs, content, "HEIGHT");
            this.appendMaxAttribute(prefs, content, "WIDTH");
            this.appendMaxAttribute(prefs, content, "SCROLLING");
            this.appendMaxAttribute(prefs, content, "STYLE");
        } else {
            this.appendAttribute(prefs, content, "HEIGHT");
            this.appendAttribute(prefs, content, "WIDTH");
            this.appendAttribute(prefs, content, "SCROLLING");
            this.appendAttribute(prefs, content, "STYLE");
        }
        content.append(">");
        content.append("<P STYLE=\"textAlign:center\"><A HREF=\"").append(source).append("\">").append(source).append("</A></P>");
        content.append("</IFRAME>");
        content.append("</TD></TR></TBODY></TABLE>");
        response.setContentType("text/html");
        response.getWriter().print(content.toString());
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        this.processPreferencesAction(request, actionResponse);
    }

    protected String getTitle(RenderRequest request) {
        String title = this.getAttributePreference(request.getPreferences(), "TITLE");
        if (!StringUtils.isEmpty((String)title)) {
            return title;
        }
        return super.getTitle(request);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String widgetSource = this.getAttributePreference(request.getPreferences(), "WIDGETSOURCE");
        if (!StringUtils.isEmpty((String)widgetSource)) {
            response.setContentType("text/html");
            response.getWriter().print(widgetSource);
        }
    }
}

