/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncleanShutdownDetectionImpl
implements UncleanShutdownDetection {
    private static final Logger LOG = LoggerFactory.getLogger(UncleanShutdownDetectionImpl.class);
    private final LedgerDirsManager ledgerDirsManager;
    static final String DIRTY_FILENAME = "DIRTY";

    public UncleanShutdownDetectionImpl(LedgerDirsManager ledgerDirsManager) {
        this.ledgerDirsManager = ledgerDirsManager;
    }

    @Override
    public void registerStartUp() throws IOException {
        for (File ledgerDir : this.ledgerDirsManager.getAllLedgerDirs()) {
            try {
                File dirtyFile = new File(ledgerDir, DIRTY_FILENAME);
                if (dirtyFile.createNewFile()) {
                    LOG.info("Created dirty file in ledger dir: {}", (Object)ledgerDir.getAbsolutePath());
                    continue;
                }
                LOG.info("Dirty file already exists in ledger dir: {}", (Object)ledgerDir.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Unable to register start-up (so an unclean shutdown cannot be detected). Dirty file of ledger dir {} could not be created.", (Object)ledgerDir.getAbsolutePath(), (Object)e);
                throw e;
            }
        }
    }

    @Override
    public void registerCleanShutdown() {
        for (File ledgerDir : this.ledgerDirsManager.getAllLedgerDirs()) {
            try {
                File dirtyFile = new File(ledgerDir, DIRTY_FILENAME);
                if (dirtyFile.exists()) {
                    boolean deleted = dirtyFile.delete();
                    if (deleted) continue;
                    LOG.error("Unable to register a clean shutdown. The dirty file of  ledger dir {} could not be deleted.", (Object)ledgerDir.getAbsolutePath());
                    continue;
                }
                LOG.error("Unable to register a clean shutdown. The dirty file of  ledger dir {} does not exist.", (Object)ledgerDir.getAbsolutePath());
            }
            catch (Throwable t) {
                LOG.error("Unable to register a clean shutdown. An error occurred while deleting  the dirty file of ledger dir {}.", (Object)ledgerDir.getAbsolutePath(), (Object)t);
            }
        }
    }

    @Override
    public boolean lastShutdownWasUnclean() {
        boolean unclean = false;
        ArrayList<String> dirtyFiles = new ArrayList<String>();
        try {
            for (File ledgerDir : this.ledgerDirsManager.getAllLedgerDirs()) {
                File dirtyFile = new File(ledgerDir, DIRTY_FILENAME);
                if (!dirtyFile.exists()) continue;
                dirtyFiles.add(dirtyFile.getAbsolutePath());
                unclean = true;
            }
        }
        catch (Throwable t) {
            LOG.error("Unable to determine if last shutdown was unclean (defaults to unclean)", t);
            unclean = true;
        }
        if (!dirtyFiles.isEmpty()) {
            LOG.info("Dirty files exist on boot-up indicating an unclean shutdown. Dirty files: {}", (Object)String.join((CharSequence)",", dirtyFiles));
        }
        return unclean;
    }
}

