/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.proto.BookieServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendCompactionService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(SuspendCompactionService.class);
    protected BookieServer bookieServer;

    public SuspendCompactionService(BookieServer bookieServer) {
        Preconditions.checkNotNull((Object)bookieServer);
        this.bookieServer = bookieServer;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            String requestBody = request.getBody();
            if (null == requestBody) {
                return new HttpServiceResponse("Empty request body", HttpServer.StatusCode.BAD_REQUEST);
            }
            Map configMap = (Map)JsonUtil.fromJson((String)requestBody, HashMap.class);
            Boolean suspendMajor = (Boolean)configMap.get("suspendMajor");
            Boolean suspendMinor = (Boolean)configMap.get("suspendMinor");
            if (suspendMajor == null && suspendMinor == null) {
                return new HttpServiceResponse("No suspendMajor or suspendMinor params found", HttpServer.StatusCode.BAD_REQUEST);
            }
            String output = "";
            if (suspendMajor != null && suspendMajor.booleanValue()) {
                output = "Suspend majorGC on BookieServer: " + this.bookieServer.toString();
                this.bookieServer.getBookie().getLedgerStorage().suspendMajorGC();
            }
            if (suspendMinor != null && suspendMinor.booleanValue()) {
                output = output + ", Suspend minorGC on BookieServer: " + this.bookieServer.toString();
                this.bookieServer.getBookie().getLedgerStorage().suspendMinorGC();
            }
            String jsonResponse = JsonUtil.toJson((Object)output);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean isMajorGcSuspend = this.bookieServer.getBookie().getLedgerStorage().isMajorGcSuspended();
            boolean isMinorGcSuspend = this.bookieServer.getBookie().getLedgerStorage().isMinorGcSuspended();
            HashMap<String, String> output = new HashMap<String, String>();
            output.put("isMajorGcSuspended", Boolean.toString(isMajorGcSuspend));
            output.put("isMinorGcSuspended", Boolean.toString(isMinorGcSuspend));
            String jsonResponse = JsonUtil.toJson(output);
            if (LOG.isDebugEnabled()) {
                LOG.debug("output body:" + jsonResponse);
            }
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT to suspend major or minor compaction, Or GET to get compaction state.");
        return response;
    }
}

