/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongDoubleAssociativeContainer;
import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.comparators.LongComparator;
import com.carrotsearch.hppc.comparators.LongDoubleComparator;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.LongDoublePredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.LongDoubleProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationLongDoubleHashMap
implements LongDoubleMap {
    public final LongDoubleHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongDoubleHashMap(LongDoubleHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongDoubleHashMap(LongDoubleHashMap delegate, LongDoubleComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongDoubleComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final double[] values;
            {
                this.keys = SortedIterationLongDoubleHashMap.this.delegate.keys;
                this.values = SortedIterationLongDoubleHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongDoubleCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongDoublePredicate predicate) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public <T extends LongDoubleProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongDoublePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public double get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public double getOrDefault(long key, double defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public double put(long key, double value) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongDoubleAssociativeContainer container) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongDoubleCursor> iterable) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public double putOrAdd(long key, double putValue, double incrementValue) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public double addTo(long key, double additionValue) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public double remove(long key) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public double indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public double indexReplace(int index, double newValue) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, double value) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public double indexRemove(int index) {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongDoubleHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongDoubleCursor> {
        private final LongDoubleCursor cursor = new LongDoubleCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongDoubleCursor fetch() {
            if (this.index < SortedIterationLongDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongDoubleHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongDoubleCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongDoubleHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongDoubleHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final SortedIterationLongDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (LongDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.index < SortedIterationLongDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongDoubleHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

