/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.policies.data.loadbalancer.TimeAverageMessageData;

public class TimeAverageBrokerData {
    private double shortTermMsgThroughputIn;
    private double shortTermMsgThroughputOut;
    private double shortTermMsgRateIn;
    private double shortTermMsgRateOut;
    private double longTermMsgThroughputIn;
    private double longTermMsgThroughputOut;
    private double longTermMsgRateIn;
    private double longTermMsgRateOut;

    public TimeAverageBrokerData(Set<String> bundles, Map<String, BundleData> data, NamespaceBundleStats defaultStats) {
        this.reset(bundles, data, defaultStats);
    }

    public void reset(Set<String> bundles, Map<String, BundleData> data, NamespaceBundleStats defaultStats) {
        this.shortTermMsgThroughputIn = 0.0;
        this.shortTermMsgThroughputOut = 0.0;
        this.shortTermMsgRateIn = 0.0;
        this.shortTermMsgRateOut = 0.0;
        this.longTermMsgThroughputIn = 0.0;
        this.longTermMsgThroughputOut = 0.0;
        this.longTermMsgRateIn = 0.0;
        this.longTermMsgRateOut = 0.0;
        for (String bundle : bundles) {
            BundleData bundleData = data.get(bundle);
            if (bundleData == null) {
                this.shortTermMsgThroughputIn += defaultStats.msgThroughputIn;
                this.shortTermMsgThroughputOut += defaultStats.msgThroughputOut;
                this.shortTermMsgRateIn += defaultStats.msgRateIn;
                this.shortTermMsgRateOut += defaultStats.msgRateOut;
                this.longTermMsgThroughputIn += defaultStats.msgThroughputIn;
                this.longTermMsgThroughputOut += defaultStats.msgThroughputOut;
                this.longTermMsgRateIn += defaultStats.msgRateIn;
                this.longTermMsgRateOut += defaultStats.msgRateOut;
                continue;
            }
            TimeAverageMessageData shortTermData = bundleData.getShortTermData();
            TimeAverageMessageData longTermData = bundleData.getLongTermData();
            this.shortTermMsgThroughputIn += shortTermData.getMsgThroughputIn();
            this.shortTermMsgThroughputOut += shortTermData.getMsgThroughputOut();
            this.shortTermMsgRateIn += shortTermData.getMsgRateIn();
            this.shortTermMsgRateOut += shortTermData.getMsgRateOut();
            this.longTermMsgThroughputIn += longTermData.getMsgThroughputIn();
            this.longTermMsgThroughputOut += longTermData.getMsgThroughputOut();
            this.longTermMsgRateIn += longTermData.getMsgRateIn();
            this.longTermMsgRateOut += longTermData.getMsgRateOut();
        }
    }

    @Generated
    public double getShortTermMsgThroughputIn() {
        return this.shortTermMsgThroughputIn;
    }

    @Generated
    public double getShortTermMsgThroughputOut() {
        return this.shortTermMsgThroughputOut;
    }

    @Generated
    public double getShortTermMsgRateIn() {
        return this.shortTermMsgRateIn;
    }

    @Generated
    public double getShortTermMsgRateOut() {
        return this.shortTermMsgRateOut;
    }

    @Generated
    public double getLongTermMsgThroughputIn() {
        return this.longTermMsgThroughputIn;
    }

    @Generated
    public double getLongTermMsgThroughputOut() {
        return this.longTermMsgThroughputOut;
    }

    @Generated
    public double getLongTermMsgRateIn() {
        return this.longTermMsgRateIn;
    }

    @Generated
    public double getLongTermMsgRateOut() {
        return this.longTermMsgRateOut;
    }

    @Generated
    public void setShortTermMsgThroughputIn(double shortTermMsgThroughputIn) {
        this.shortTermMsgThroughputIn = shortTermMsgThroughputIn;
    }

    @Generated
    public void setShortTermMsgThroughputOut(double shortTermMsgThroughputOut) {
        this.shortTermMsgThroughputOut = shortTermMsgThroughputOut;
    }

    @Generated
    public void setShortTermMsgRateIn(double shortTermMsgRateIn) {
        this.shortTermMsgRateIn = shortTermMsgRateIn;
    }

    @Generated
    public void setShortTermMsgRateOut(double shortTermMsgRateOut) {
        this.shortTermMsgRateOut = shortTermMsgRateOut;
    }

    @Generated
    public void setLongTermMsgThroughputIn(double longTermMsgThroughputIn) {
        this.longTermMsgThroughputIn = longTermMsgThroughputIn;
    }

    @Generated
    public void setLongTermMsgThroughputOut(double longTermMsgThroughputOut) {
        this.longTermMsgThroughputOut = longTermMsgThroughputOut;
    }

    @Generated
    public void setLongTermMsgRateIn(double longTermMsgRateIn) {
        this.longTermMsgRateIn = longTermMsgRateIn;
    }

    @Generated
    public void setLongTermMsgRateOut(double longTermMsgRateOut) {
        this.longTermMsgRateOut = longTermMsgRateOut;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeAverageBrokerData)) {
            return false;
        }
        TimeAverageBrokerData other = (TimeAverageBrokerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getShortTermMsgThroughputIn(), other.getShortTermMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getShortTermMsgThroughputOut(), other.getShortTermMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getShortTermMsgRateIn(), other.getShortTermMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getShortTermMsgRateOut(), other.getShortTermMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongTermMsgThroughputIn(), other.getLongTermMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongTermMsgThroughputOut(), other.getLongTermMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongTermMsgRateIn(), other.getLongTermMsgRateIn()) != 0) {
            return false;
        }
        return Double.compare(this.getLongTermMsgRateOut(), other.getLongTermMsgRateOut()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeAverageBrokerData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $shortTermMsgThroughputIn = Double.doubleToLongBits(this.getShortTermMsgThroughputIn());
        result = result * 59 + (int)($shortTermMsgThroughputIn >>> 32 ^ $shortTermMsgThroughputIn);
        long $shortTermMsgThroughputOut = Double.doubleToLongBits(this.getShortTermMsgThroughputOut());
        result = result * 59 + (int)($shortTermMsgThroughputOut >>> 32 ^ $shortTermMsgThroughputOut);
        long $shortTermMsgRateIn = Double.doubleToLongBits(this.getShortTermMsgRateIn());
        result = result * 59 + (int)($shortTermMsgRateIn >>> 32 ^ $shortTermMsgRateIn);
        long $shortTermMsgRateOut = Double.doubleToLongBits(this.getShortTermMsgRateOut());
        result = result * 59 + (int)($shortTermMsgRateOut >>> 32 ^ $shortTermMsgRateOut);
        long $longTermMsgThroughputIn = Double.doubleToLongBits(this.getLongTermMsgThroughputIn());
        result = result * 59 + (int)($longTermMsgThroughputIn >>> 32 ^ $longTermMsgThroughputIn);
        long $longTermMsgThroughputOut = Double.doubleToLongBits(this.getLongTermMsgThroughputOut());
        result = result * 59 + (int)($longTermMsgThroughputOut >>> 32 ^ $longTermMsgThroughputOut);
        long $longTermMsgRateIn = Double.doubleToLongBits(this.getLongTermMsgRateIn());
        result = result * 59 + (int)($longTermMsgRateIn >>> 32 ^ $longTermMsgRateIn);
        long $longTermMsgRateOut = Double.doubleToLongBits(this.getLongTermMsgRateOut());
        result = result * 59 + (int)($longTermMsgRateOut >>> 32 ^ $longTermMsgRateOut);
        return result;
    }

    @Generated
    public String toString() {
        return "TimeAverageBrokerData(shortTermMsgThroughputIn=" + this.getShortTermMsgThroughputIn() + ", shortTermMsgThroughputOut=" + this.getShortTermMsgThroughputOut() + ", shortTermMsgRateIn=" + this.getShortTermMsgRateIn() + ", shortTermMsgRateOut=" + this.getShortTermMsgRateOut() + ", longTermMsgThroughputIn=" + this.getLongTermMsgThroughputIn() + ", longTermMsgThroughputOut=" + this.getLongTermMsgThroughputOut() + ", longTermMsgRateIn=" + this.getLongTermMsgRateIn() + ", longTermMsgRateOut=" + this.getLongTermMsgRateOut() + ")";
    }

    @Generated
    public TimeAverageBrokerData() {
    }
}

