/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.OpenBuilderBase;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedGenericCallback;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerOpenOp {
    static final Logger LOG = LoggerFactory.getLogger(LedgerOpenOp.class);
    final BookKeeper bk;
    final long ledgerId;
    final AsyncCallback.OpenCallback cb;
    final Object ctx;
    ReadOnlyLedgerHandle lh;
    final byte[] passwd;
    boolean doRecovery = true;
    boolean administrativeOpen = false;
    long startTime;
    final OpStatsLogger openOpLogger;
    final BookKeeper.DigestType suggestedDigestType;
    final boolean enableDigestAutodetection;

    public LedgerOpenOp(BookKeeper bk, BookKeeperClientStats clientStats, long ledgerId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.enableDigestAutodetection = bk.getConf().getEnableDigestTypeAutodetection();
        this.suggestedDigestType = digestType;
        this.openOpLogger = clientStats.getOpenOpLogger();
    }

    public LedgerOpenOp(BookKeeper bk, BookKeeperClientStats clientStats, long ledgerId, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
        this.passwd = bk.getConf().getBookieRecoveryPasswd();
        this.administrativeOpen = true;
        this.enableDigestAutodetection = false;
        this.suggestedDigestType = bk.conf.getBookieRecoveryDigestType();
        this.openOpLogger = clientStats.getOpenOpLogger();
    }

    public void initiate() {
        this.startTime = MathUtils.nowInNano();
        ((CompletableFuture)this.bk.getLedgerManager().readLedgerMetadata(this.ledgerId).thenAcceptAsync(this::openWithMetadata, (Executor)this.bk.getScheduler().chooseThread(this.ledgerId))).exceptionally(exception -> {
            this.openComplete(BKException.getExceptionCode(exception), null);
            return null;
        });
    }

    public void initiateWithoutRecovery() {
        this.doRecovery = false;
        this.initiate();
    }

    private CompletableFuture<Void> closeLedgerHandleAsync() {
        if (this.lh != null) {
            return this.lh.closeAsync();
        }
        return CompletableFuture.completedFuture(null);
    }

    private void openWithMetadata(Versioned<LedgerMetadata> versionedMetadata) {
        byte[] passwd;
        LedgerMetadata metadata = versionedMetadata.getValue();
        BookKeeper.DigestType digestType = this.enableDigestAutodetection && metadata.hasPassword() ? BookKeeper.DigestType.fromApiDigestType(metadata.getDigestType()) : this.suggestedDigestType;
        if (this.administrativeOpen && metadata.hasPassword()) {
            passwd = metadata.getPassword();
            digestType = BookKeeper.DigestType.fromApiDigestType(metadata.getDigestType());
        } else {
            passwd = this.passwd;
            if (metadata.hasPassword()) {
                if (!Arrays.equals(passwd, metadata.getPassword())) {
                    LOG.error("Provided passwd does not match that in metadata");
                    this.openComplete(-102, null);
                    return;
                }
                if (this.suggestedDigestType != BookKeeper.DigestType.fromApiDigestType(metadata.getDigestType()) && !this.enableDigestAutodetection) {
                    LOG.error("Provided digest does not match that in metadata");
                    this.openComplete(-5, null);
                    return;
                }
            }
        }
        try {
            this.lh = new ReadOnlyLedgerHandle(this.bk.getClientCtx(), this.ledgerId, versionedMetadata, digestType, passwd, !this.doRecovery);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while opening ledger: " + this.ledgerId, (Throwable)e);
            this.openComplete(-4, null);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.openComplete(-14, null);
            return;
        }
        if (metadata.isClosed()) {
            this.openComplete(0, this.lh);
            return;
        }
        if (this.doRecovery) {
            this.lh.recover((BookkeeperInternalCallbacks.GenericCallback<Void>)new OrderedGenericCallback<Void>(this.bk.getMainWorkerPool(), this.ledgerId){

                @Override
                public void safeOperationComplete(int rc, Void result) {
                    if (rc == 0) {
                        LedgerOpenOp.this.openComplete(0, LedgerOpenOp.this.lh);
                    } else {
                        LedgerOpenOp.this.closeLedgerHandleAsync().whenComplete((ignore, ex) -> {
                            if (ex != null) {
                                LOG.error("Ledger {} close failed", (Object)LedgerOpenOp.this.ledgerId, ex);
                            }
                            if (rc == -102 || rc == -23) {
                                LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(rc), null);
                            } else {
                                LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(-10), null);
                            }
                        });
                    }
                }

                public String toString() {
                    return String.format("Recover(%d)", LedgerOpenOp.this.ledgerId);
                }
            });
        } else {
            this.lh.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

                @Override
                public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                    if (rc == -23) {
                        LedgerOpenOp.this.closeLedgerHandleAsync().whenComplete((r, ex) -> {
                            if (ex != null) {
                                LOG.error("Ledger {} close failed", (Object)LedgerOpenOp.this.ledgerId, ex);
                            }
                            LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(rc), null);
                        });
                    } else if (rc != 0) {
                        LedgerOpenOp.this.closeLedgerHandleAsync().whenComplete((r, ex) -> {
                            if (ex != null) {
                                LOG.error("Ledger {} close failed", (Object)LedgerOpenOp.this.ledgerId, ex);
                            }
                            LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(-1), null);
                        });
                    } else {
                        LedgerOpenOp.this.lh.lastAddConfirmed = LedgerOpenOp.this.lh.lastAddPushed = lastConfirmed;
                        LedgerOpenOp.this.openComplete(0, LedgerOpenOp.this.lh);
                    }
                }
            }, null);
        }
    }

    void openComplete(int rc, LedgerHandle lh) {
        if (0 != rc) {
            this.openOpLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.openOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        }
        if (lh != null) {
            lh.executeOrdered(() -> this.cb.openComplete(rc, lh, this.ctx));
        } else {
            this.cb.openComplete(rc, null, this.ctx);
        }
    }

    static final class OpenBuilderImpl
    extends OpenBuilderBase {
        private final BookKeeper bk;

        OpenBuilderImpl(BookKeeper bookkeeper) {
            this.bk = bookkeeper;
        }

        @Override
        public CompletableFuture<ReadHandle> execute() {
            CompletableFuture<ReadHandle> future = new CompletableFuture<ReadHandle>();
            SyncCallbackUtils.SyncOpenCallback callback = new SyncCallbackUtils.SyncOpenCallback(future);
            this.open(callback);
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AsyncCallback.OpenCallback cb) {
            int validateRc = this.validate();
            if (0 != validateRc) {
                cb.openComplete(validateRc, null, null);
                return;
            }
            LedgerOpenOp op = new LedgerOpenOp(this.bk, this.bk.getClientCtx().getClientStats(), this.ledgerId, BookKeeper.DigestType.fromApiDigestType(this.digestType), this.password, cb, null);
            ReentrantReadWriteLock closeLock = this.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.bk.isClosed()) {
                    cb.openComplete(-19, null, null);
                    return;
                }
                if (this.recovery) {
                    op.initiate();
                } else {
                    op.initiateWithoutRecovery();
                }
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }
}

