/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.apache.pulsar.functions.worker.service.api.FunctionsV2;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/functions")
public class FunctionsApiV2Resource
extends FunctionApiResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionsApiV2Resource.class);

    FunctionsV2<? extends WorkerService> functions() {
        return this.get().getFunctionsV2();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Function in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function already exists, etc.)"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="Pulsar Function successfully created")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response registerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson) {
        return this.functions().registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, this.authParams());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function doesn't exist, etc.)"), @ApiResponse(code=200, message="Pulsar Function successfully updated")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public Response updateFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="functionDetails") String functionDetailsJson) {
        return this.functions().updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionDetailsJson, this.authParams());
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function doesn't exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="The function was successfully deleted")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response deregisterFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().deregisterFunction(tenant, namespace, functionName, this.authParams());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Function currently running in cluster mode", response=Function.FunctionMetaData.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public Response getFunctionInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions().getFunctionInfo(tenant, namespace, functionName, this.authParams());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function instance", response=InstanceCommunication.FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/status")
    public Response getFunctionInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions().getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function running in cluster mode", response=InstanceCommunication.FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}/{functionName}/status")
    public Response getFunctionStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions().getFunctionStatusV2(tenant, namespace, functionName, this.uri.getRequestUri(), this.authParams());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Functions currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}")
    public Response listFunctions(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.functions().listFunctions(tenant, namespace, this.authParams());
    }

    @POST
    @ApiOperation(value="Triggers a Pulsar Function with a user-specified value or file data", response=Message.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/trigger")
    @Consumes(value={"multipart/form-data"})
    public Response triggerFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @FormDataParam(value="data") String triggerValue, @FormDataParam(value="dataStream") InputStream triggerStream, @FormDataParam(value="topic") String topic) {
        return this.functions().triggerFunction(tenant, namespace, functionName, triggerValue, triggerStream, topic, this.authParams());
    }

    @GET
    @ApiOperation(value="Fetch the current state associated with a Pulsar Function", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The key does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    public Response getFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key) {
        return this.functions().getFunctionState(tenant, namespace, functionName, key, this.authParams());
    }

    @POST
    @ApiOperation(value="Restart function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this function"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions().restartFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @POST
    @ApiOperation(value="Restart all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/restart")
    @Consumes(value={"application/json"})
    public Response restartFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().restartFunctionInstances(tenant, namespace, functionName, this.authParams());
    }

    @POST
    @ApiOperation(value="Stop function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="instanceId") String instanceId) {
        return this.functions().stopFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @POST
    @ApiOperation(value="Stop all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/stop")
    @Consumes(value={"application/json"})
    public Response stopFunction(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName) {
        return this.functions().stopFunctionInstances(tenant, namespace, functionName, this.authParams());
    }

    @POST
    @ApiOperation(value="Uploads Pulsar Function file data (admin only)", hidden=true)
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public Response uploadFunction(@FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="path") String path) {
        return this.functions().uploadFunction(uploadedInputStream, path, this.authParams());
    }

    @GET
    @ApiOperation(value="Downloads Pulsar Function file data (admin only)", hidden=true)
    @Path(value="/download")
    public Response downloadFunction(@QueryParam(value="path") String path) {
        return this.functions().downloadFunction(path, this.authParams());
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/connectors")
    @Deprecated
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.functions().getListOfConnectors();
    }
}

