/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelayedDeliveryTracker
implements DelayedDeliveryTracker,
TimerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDelayedDeliveryTracker.class);
    protected final AbstractPersistentDispatcherMultipleConsumers dispatcher;
    protected final Timer timer;
    protected Timeout timeout;
    private long currentTimeoutTarget;
    private long lastTickRun;
    protected long tickTimeMillis;
    protected final Clock clock;
    private final boolean isDelayedDeliveryDeliverAtTimeStrict;

    public AbstractDelayedDeliveryTracker(AbstractPersistentDispatcherMultipleConsumers dispatcher, Timer timer, long tickTimeMillis, boolean isDelayedDeliveryDeliverAtTimeStrict) {
        this(dispatcher, timer, tickTimeMillis, Clock.systemUTC(), isDelayedDeliveryDeliverAtTimeStrict);
    }

    public AbstractDelayedDeliveryTracker(AbstractPersistentDispatcherMultipleConsumers dispatcher, Timer timer, long tickTimeMillis, Clock clock, boolean isDelayedDeliveryDeliverAtTimeStrict) {
        this.dispatcher = dispatcher;
        this.timer = timer;
        this.tickTimeMillis = tickTimeMillis;
        this.clock = clock;
        this.isDelayedDeliveryDeliverAtTimeStrict = isDelayedDeliveryDeliverAtTimeStrict;
    }

    protected long getCutoffTime() {
        return this.isDelayedDeliveryDeliverAtTimeStrict ? this.clock.millis() : this.clock.millis() + this.tickTimeMillis;
    }

    @Override
    public void resetTickTime(long tickTime) {
        if (this.tickTimeMillis != tickTime) {
            this.tickTimeMillis = tickTime;
        }
    }

    protected void updateTimer() {
        long now;
        long delayMillis;
        if (this.getNumberOfDelayedMessages() == 0L) {
            if (this.timeout != null) {
                this.currentTimeoutTarget = -1L;
                this.timeout.cancel();
                this.timeout = null;
            }
            return;
        }
        long timestamp = this.nextDeliveryTime();
        if (timestamp == this.currentTimeoutTarget) {
            return;
        }
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        if ((delayMillis = timestamp - (now = this.clock.millis())) < 0L) {
            return;
        }
        long remainingTickDelayMillis = this.lastTickRun + this.tickTimeMillis - now;
        long calculatedDelayMillis = Math.max(delayMillis, remainingTickDelayMillis);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Start timer in {} millis", (Object)this.dispatcher.getName(), (Object)calculatedDelayMillis);
        }
        this.currentTimeoutTarget = timestamp;
        this.timeout = this.timer.newTimeout((TimerTask)this, calculatedDelayMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Timer triggered", (Object)this.dispatcher.getName());
        }
        if (timeout == null || timeout.isCancelled()) {
            return;
        }
        AbstractPersistentDispatcherMultipleConsumers abstractPersistentDispatcherMultipleConsumers = this.dispatcher;
        synchronized (abstractPersistentDispatcherMultipleConsumers) {
            this.lastTickRun = this.clock.millis();
            this.currentTimeoutTarget = -1L;
            this.timeout = null;
            this.dispatcher.readMoreEntriesAsync();
        }
    }

    @Override
    public void close() {
        if (this.timeout != null) {
            this.timeout.cancel();
            this.timeout = null;
        }
    }

    protected abstract long nextDeliveryTime();
}

