/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.function.LongSupplier;
import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.MonotonicClock;

public class DynamicRateAsyncTokenBucket
extends AsyncTokenBucket {
    private final LongSupplier rateFunction;
    private final LongSupplier ratePeriodNanosFunction;
    private final double capacityFactor;
    private final double targetFillFactorAfterThrottling;

    protected DynamicRateAsyncTokenBucket(double capacityFactor, LongSupplier rateFunction, MonotonicClock clockSource, long addTokensResolutionNanos, LongSupplier ratePeriodNanosFunction, double initialTokensFactor, double targetFillFactorAfterThrottling) {
        super(clockSource, addTokensResolutionNanos);
        this.capacityFactor = capacityFactor;
        this.rateFunction = rateFunction;
        this.ratePeriodNanosFunction = ratePeriodNanosFunction;
        this.targetFillFactorAfterThrottling = targetFillFactorAfterThrottling;
        this.tokens = (long)((double)rateFunction.getAsLong() * initialTokensFactor);
        this.getTokens();
    }

    @Override
    protected long getRatePeriodNanos() {
        return this.ratePeriodNanosFunction.getAsLong();
    }

    @Override
    protected long getTargetAmountOfTokensAfterThrottling() {
        return (long)((double)this.getRate() * this.targetFillFactorAfterThrottling);
    }

    @Override
    public long getCapacity() {
        return this.capacityFactor == 1.0 ? this.getRate() : (long)((double)this.getRate() * this.capacityFactor);
    }

    @Override
    public long getRate() {
        return this.rateFunction.getAsLong();
    }

    @Override
    protected long getNanosForOneToken() {
        return this.getRatePeriodNanos() / this.getRate();
    }
}

