/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandleAttributes;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandleStats;

public class OpenTelemetryTransactionPendingAckStoreStats
implements AutoCloseable {
    public static final String ACK_COUNTER = "pulsar.broker.transaction.pending.ack.store.transaction.count";
    private final ObservableLongCounter ackCounter;

    public OpenTelemetryTransactionPendingAckStoreStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.ackCounter = meter.counterBuilder(ACK_COUNTER).setUnit("{transaction}").setDescription("The number of transactions handled by the persistent ack store.").buildWithCallback(measurement -> pulsar.getBrokerService().getTopics().values().stream().filter(topicFuture -> topicFuture.isDone() && !topicFuture.isCompletedExceptionally()).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).filter(Topic::isPersistent).map(Topic::getSubscriptions).forEach(subs -> subs.forEach((__, sub) -> this.recordMetricsForSubscription((ObservableLongMeasurement)measurement, (Subscription)sub))));
    }

    @Override
    public void close() {
        this.ackCounter.close();
    }

    private void recordMetricsForSubscription(ObservableLongMeasurement measurement, Subscription subscription) {
        assert (subscription instanceof PersistentSubscription);
        PendingAckHandleStats stats = ((PersistentSubscription)subscription).getPendingAckHandle().getPendingAckHandleStats();
        if (stats != null) {
            PendingAckHandleAttributes attributes = stats.getAttributes();
            measurement.record(stats.getCommitSuccessCount(), attributes.getCommitSuccessAttributes());
            measurement.record(stats.getCommitFailedCount(), attributes.getCommitFailureAttributes());
            measurement.record(stats.getAbortSuccessCount(), attributes.getAbortSuccessAttributes());
            measurement.record(stats.getAbortFailedCount(), attributes.getAbortFailureAttributes());
        }
    }
}

