/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import io.grpc.ClientCall;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.common.Attributes;
import io.oxia.client.grpc.OxiaStubManager;
import io.oxia.client.metrics.Counter;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.metrics.Unit;
import io.oxia.client.shard.ShardManager;
import io.oxia.proto.GetSequenceUpdatesRequest;
import io.oxia.proto.GetSequenceUpdatesResponse;
import io.oxia.proto.OxiaClientGrpc;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceUpdates
implements Closeable,
StreamObserver<GetSequenceUpdatesResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SequenceUpdates.class);
    private final String key;
    private final String partitionKey;
    private final Consumer<String> listener;
    private final OxiaStubManager stubManager;
    private final ShardManager shardManager;
    private final Counter counterSequenceUpdatesReceived;
    private final Function<Void, Boolean> isClientClosed;
    private boolean closed = false;
    private ClientCall<GetSequenceUpdatesRequest, GetSequenceUpdatesResponse> call;

    SequenceUpdates(@NonNull String key, @NonNull String partitionKey, @NonNull Consumer<String> listener, @NonNull OxiaStubManager stubManager, @NonNull ShardManager shardManager, @NonNull InstrumentProvider instrumentProvider, Function<Void, Boolean> isClientClosed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (partitionKey == null) {
            throw new NullPointerException("partitionKey is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (stubManager == null) {
            throw new NullPointerException("stubManager is marked non-null but is null");
        }
        if (shardManager == null) {
            throw new NullPointerException("shardManager is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        this.key = key;
        this.partitionKey = partitionKey;
        this.listener = listener;
        this.stubManager = stubManager;
        this.shardManager = shardManager;
        this.isClientClosed = isClientClosed;
        this.counterSequenceUpdatesReceived = instrumentProvider.newCounter("oxia.client.sequence.updates.received", Unit.Events, "The total number of sequence updates received", Attributes.empty());
        this.createStream();
    }

    private synchronized void createStream() {
        if (this.closed) {
            return;
        }
        long shardId = this.shardManager.getShardForKey(this.partitionKey);
        String leader = this.shardManager.leader(shardId);
        OxiaClientGrpc.OxiaClientStub stub = this.stubManager.getStub(leader).async();
        GetSequenceUpdatesRequest request = GetSequenceUpdatesRequest.newBuilder().setShard(shardId).setKey(this.key).build();
        this.call = stub.getChannel().newCall(OxiaClientGrpc.getGetSequenceUpdatesMethod(), stub.getCallOptions());
        ClientCalls.asyncServerStreamingCall(this.call, (Object)request, (StreamObserver)this);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.call.cancel("closing streaming", null);
    }

    public void onNext(GetSequenceUpdatesResponse value) {
        this.listener.accept(value.getHighestSequenceKey());
        this.counterSequenceUpdatesReceived.increment();
    }

    public synchronized void onError(Throwable t) {
        if (this.closed || this.isClientClosed.apply(null).booleanValue()) {
            return;
        }
        log.warn("Failure while processing sequence updates: {}", (Object)t.getMessage(), (Object)t);
        this.createStream();
    }

    public synchronized void onCompleted() {
        this.createStream();
    }
}

