/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.topics.TopicList;
import org.apache.pulsar.common.topics.TopicsPattern;

public class GetTopicsResult {
    private final List<String> nonPartitionedOrPartitionTopics;
    private final boolean filtered;
    private final String topicsHash;
    private final boolean changed;
    private volatile List<String> topics;

    public GetTopicsResult(List<String> nonPartitionedOrPartitionTopics, String topicsHash, boolean filtered, boolean changed) {
        this.nonPartitionedOrPartitionTopics = nonPartitionedOrPartitionTopics;
        this.topicsHash = topicsHash;
        this.filtered = filtered;
        this.changed = changed;
    }

    public GetTopicsResult(String[] nonPartitionedOrPartitionTopics) {
        this(Arrays.asList(nonPartitionedOrPartitionTopics), null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTopics() {
        if (this.topics != null) {
            return this.topics;
        }
        GetTopicsResult getTopicsResult = this;
        synchronized (getTopicsResult) {
            if (this.topics != null) {
                return this.topics;
            }
            ArrayList<String> grouped = new ArrayList<String>();
            for (String topic : this.nonPartitionedOrPartitionTopics) {
                String partitionedTopic = TopicName.get(topic).getPartitionedTopicName();
                if (grouped.contains(partitionedTopic)) continue;
                grouped.add(partitionedTopic);
            }
            this.topics = grouped;
            return this.topics;
        }
    }

    public GetTopicsResult filterTopics(TopicsPattern topicsPattern) {
        List<String> topicsFiltered = TopicList.filterTopics(this.getTopics(), topicsPattern);
        if (topicsFiltered.equals(this.getTopics())) {
            GetTopicsResult newObj = new GetTopicsResult(this.nonPartitionedOrPartitionTopics, null, true, true);
            newObj.topics = this.topics;
            return newObj;
        }
        HashSet<String> topicsFilteredSet = new HashSet<String>(topicsFiltered);
        ArrayList<String> newTps = new ArrayList<String>();
        for (String tp : this.nonPartitionedOrPartitionTopics) {
            if (!topicsFilteredSet.contains(TopicName.get(tp).getPartitionedTopicName())) continue;
            newTps.add(tp);
        }
        GetTopicsResult newObj = new GetTopicsResult(newTps, null, true, true);
        newObj.topics = topicsFiltered;
        return newObj;
    }

    @Generated
    public String toString() {
        return "GetTopicsResult(nonPartitionedOrPartitionTopics=" + String.valueOf(this.getNonPartitionedOrPartitionTopics()) + ", filtered=" + this.isFiltered() + ", topicsHash=" + this.getTopicsHash() + ", changed=" + this.isChanged() + ", topics=" + String.valueOf(this.getTopics()) + ")";
    }

    @Generated
    public List<String> getNonPartitionedOrPartitionTopics() {
        return this.nonPartitionedOrPartitionTopics;
    }

    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    @Generated
    public String getTopicsHash() {
        return this.topicsHash;
    }

    @Generated
    public boolean isChanged() {
        return this.changed;
    }
}

