/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.upgrade.AbstractStoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;

public class UpgradeFrom6To7
extends AbstractStoreUpgrade {
    private static final int DEFAULT_CONFIG_VERSION = 0;

    @Override
    public void performUpgrade(Environment environment, UpgradeInteractionHandler handler, ConfiguredObject<?> parent) {
        this.reportStarting(environment, 6);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        Database versionDb = environment.openDatabase(null, "CONFIG_VERSION", dbConfig);
        if (versionDb.count() == 0L) {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            IntegerBinding.intToEntry((int)0, (DatabaseEntry)value);
            ByteBinding.byteToEntry((byte)0, (DatabaseEntry)key);
            OperationStatus status = versionDb.put(null, key, value);
            if (status != OperationStatus.SUCCESS) {
                throw new StoreException("Error initialising config version: " + String.valueOf(status));
            }
        }
        versionDb.close();
        this.reportFinished(environment, 7);
    }
}

