/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.user.connection.limits.config.FileParser;
import org.apache.qpid.server.user.connection.limits.config.RuleSetCreator;
import org.apache.qpid.server.user.connection.limits.plugins.AbstractConnectionLimitProvider;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRuleImpl;
import org.apache.qpid.server.user.connection.limits.plugins.FileBasedConnectionLimitProvider;

public abstract class AbstractFileBasedConnectionLimitProvider<C extends AbstractFileBasedConnectionLimitProvider<C>>
extends AbstractConnectionLimitProvider<C>
implements FileBasedConnectionLimitProvider<C> {
    static final String FILE_PROVIDER_TYPE = "ConnectionLimitFile";
    @ManagedAttributeField(afterSet="reloadSourceFile")
    private String _path;

    public AbstractFileBasedConnectionLimitProvider(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public void reload() {
        this.authorise(Operation.UPDATE);
        this.reloadSourceFile();
    }

    @Override
    public Long getDefaultFrequencyPeriod() {
        return Optional.ofNullable(this.creator()).map(RuleSetCreator::getDefaultFrequencyPeriod).orElseGet(() -> (Long)this.getContextValue(Long.class, "qpid.broker.connectionLimiter.frequencyPeriodInMillis"));
    }

    @Override
    public List<ConnectionLimitRule> getRules() {
        return Optional.ofNullable(this.creator()).orElseGet(Collections::emptyList).stream().map(ConnectionLimitRuleImpl::new).collect(Collectors.toList());
    }

    @Override
    public void resetCounters() {
        this.changeAttributes(Collections.emptyMap());
    }

    private void reloadSourceFile() {
        try {
            this.forceNewRuleSetCreator();
            this.changeAttributes(Collections.emptyMap());
        }
        catch (RuntimeException e) {
            throw new IllegalConfigurationException("Failed to reload the connection limit file", (Throwable)e);
        }
    }

    @Override
    protected RuleSetCreator newRuleSetCreator() {
        RuleSetCreator creator = FileParser.parse(this.getPath());
        if (!creator.isDefaultFrequencyPeriodSet()) {
            creator.setDefaultFrequencyPeriod((Long)this.getContextValue(Long.class, "qpid.broker.connectionLimiter.frequencyPeriodInMillis"));
        }
        return creator;
    }
}

