/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.internal.ServerUpgradeRequestImpl;
import org.eclipse.jetty.websocket.core.server.internal.ServerUpgradeResponseImpl;

public abstract class WebSocketNegotiation {
    private final ServerUpgradeRequest request;
    private final ServerUpgradeResponse response;
    private final Callback callback;
    private final WebSocketComponents components;
    private String version;
    private List<ExtensionConfig> offeredExtensions;
    private List<ExtensionConfig> negotiatedExtensions;
    private List<String> offeredProtocols;
    private String protocol;

    public WebSocketNegotiation(Request request, Response response, Callback callback, WebSocketComponents webSocketComponents) {
        this.request = new ServerUpgradeRequestImpl(this, request);
        this.response = new ServerUpgradeResponseImpl(this, response);
        this.callback = callback;
        this.components = webSocketComponents;
    }

    public ServerUpgradeRequest getRequest() {
        return this.request;
    }

    public ServerUpgradeResponse getResponse() {
        return this.response;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public void negotiate() throws BadMessageException {
        try {
            this.negotiateHeaders(this.request);
        }
        catch (Throwable x) {
            throw new BadMessageException("Invalid upgrade request", x);
        }
    }

    protected void negotiateHeaders(Request baseRequest) {
        QuotedCSV extensions = null;
        QuotedCSV protocols = null;
        for (HttpField field : baseRequest.getHeaders()) {
            if (field.getHeader() == null) continue;
            switch (field.getHeader()) {
                case SEC_WEBSOCKET_VERSION: {
                    this.version = field.getValue();
                    break;
                }
                case SEC_WEBSOCKET_EXTENSIONS: {
                    if (extensions == null) {
                        extensions = new QuotedCSV(new String[]{field.getValue()});
                        break;
                    }
                    extensions.addValue(field.getValue());
                    break;
                }
                case SEC_WEBSOCKET_SUBPROTOCOL: {
                    if (protocols == null) {
                        protocols = new QuotedCSV(new String[]{field.getValue()});
                        break;
                    }
                    protocols.addValue(field.getValue());
                    break;
                }
            }
        }
        Set available = this.components.getExtensionRegistry().getAvailableExtensionNames();
        this.offeredExtensions = extensions == null ? Collections.emptyList() : extensions.getValues().stream().map(ExtensionConfig::parse).filter(ec -> available.contains(ec.getName()) && !ec.getName().startsWith("@")).collect(Collectors.toList());
        this.offeredExtensions.forEach(ExtensionConfig::removeInternalParameters);
        this.offeredProtocols = protocols == null ? Collections.emptyList() : protocols.getValues();
        this.negotiatedExtensions = new ArrayList<ExtensionConfig>();
        for (ExtensionConfig config : this.offeredExtensions) {
            long matches = this.negotiatedExtensions.stream().filter(negotiatedConfig -> negotiatedConfig.getName().equals(config.getName())).count();
            if (matches != 0L) continue;
            this.negotiatedExtensions.add(new ExtensionConfig(config));
        }
    }

    public abstract boolean validateHeaders();

    public String getVersion() {
        return this.version;
    }

    public String getSubprotocol() {
        return this.protocol;
    }

    public void setSubprotocol(String protocol) {
        this.protocol = protocol;
    }

    public List<String> getOfferedSubprotocols() {
        return this.offeredProtocols;
    }

    public List<ExtensionConfig> getOfferedExtensions() {
        return this.offeredExtensions;
    }

    public List<ExtensionConfig> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    public void setNegotiatedExtensions(List<ExtensionConfig> extensions) {
        if (extensions == this.offeredExtensions) {
            return;
        }
        this.negotiatedExtensions = extensions;
    }

    public String toString() {
        return String.format("%s@%x{uri=%s,oe=%s,op=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getRequest().getHttpURI(), this.getOfferedExtensions(), this.getOfferedSubprotocols());
    }
}

