/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.crypto.key.kms.server;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType.Type;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestKMSACLs {

  String ipAddress = "192.168.90.1";
  
  @Test
  public void testDefaults() {
    KMSACLs acls = new KMSACLs(new Configuration(false));
    for (Type type : Type.values()) {
      Assert.assertTrue(acls.hasAccess(type,
          UserGroupInformation.createRemoteUser("foo"), ipAddress));
    }
  }

  @Test
  public void testCustom()  {
    Configuration conf = new Configuration(false);
    for (Type type : Type.values()) {
      conf.set(type.getAclConfigKey(), type.toString() + " ");
    }
    KMSACLs acls = new KMSACLs(conf);
    for (Type type : Type.values()) {
      Assert.assertTrue(acls.hasAccess(type,
          UserGroupInformation.createRemoteUser(type.toString()), ipAddress));
      Assert.assertFalse(acls.hasAccess(type,
          UserGroupInformation.createRemoteUser("foo"), ipAddress));
    }
  }
}
