/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearIndicesCacheRequest
extends BroadcastRequest<ClearIndicesCacheRequest> {
    private boolean queryCache = false;
    private boolean fieldDataCache = false;
    private boolean requestCache = false;
    private String[] fields = Strings.EMPTY_ARRAY;

    public ClearIndicesCacheRequest(StreamInput in) throws IOException {
        super(in);
        this.queryCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        if (in.getVersion().before(Version.V_6_0_0_beta1)) {
            in.readBoolean();
        }
        this.fields = in.readStringArray();
        this.requestCache = in.readBoolean();
    }

    public ClearIndicesCacheRequest(String ... indices) {
        super(indices);
    }

    public boolean queryCache() {
        return this.queryCache;
    }

    public ClearIndicesCacheRequest queryCache(boolean queryCache) {
        this.queryCache = queryCache;
        return this;
    }

    public boolean requestCache() {
        return this.requestCache;
    }

    public ClearIndicesCacheRequest requestCache(boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public ClearIndicesCacheRequest fieldDataCache(boolean fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        return this;
    }

    public ClearIndicesCacheRequest fields(String ... fields) {
        this.fields = fields == null ? Strings.EMPTY_ARRAY : fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.queryCache);
        out.writeBoolean(this.fieldDataCache);
        if (out.getVersion().before(Version.V_6_0_0_beta1)) {
            out.writeBoolean(false);
        }
        out.writeStringArrayNullable(this.fields);
        out.writeBoolean(this.requestCache);
    }
}

