/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ArrayUtils;

public class GetIndexRequest
extends ClusterInfoRequest<GetIndexRequest> {
    private static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS};
    private Feature[] features = DEFAULT_FEATURES;
    private boolean humanReadable = false;
    private transient boolean includeDefaults = false;

    public GetIndexRequest() {
    }

    public GetIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.features = in.readArray(i -> Feature.fromId(i.readByte()), Feature[]::new);
        this.humanReadable = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.includeDefaults = in.readBoolean();
        }
    }

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new IllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... features) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(features);
        }
        return this.features(ArrayUtils.concat(this.features(), features, Feature.class));
    }

    public Feature[] features() {
        return this.features;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public GetIndexRequest humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public GetIndexRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray((o, f) -> o.writeByte(((Feature)f).id), this.features);
        out.writeBoolean(this.humanReadable);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeBoolean(this.includeDefaults);
        }
    }

    public static final class Feature
    extends Enum<Feature> {
        public static final /* enum */ Feature ALIASES = new Feature(0);
        public static final /* enum */ Feature MAPPINGS = new Feature(1);
        public static final /* enum */ Feature SETTINGS = new Feature(2);
        private static final Feature[] FEATURES;
        private final byte id;
        private static final /* synthetic */ Feature[] $VALUES;

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public static Feature valueOf(String name) {
            return Enum.valueOf(Feature.class, name);
        }

        private Feature(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Feature fromId(byte id) {
            if (id < 0 || id >= FEATURES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return FEATURES[id];
        }

        static {
            $VALUES = new Feature[]{ALIASES, MAPPINGS, SETTINGS};
            FEATURES = new Feature[Feature.values().length];
            for (Feature feature : Feature.values()) {
                assert (feature.id() < FEATURES.length && feature.id() >= 0);
                Feature.FEATURES[feature.id] = feature;
            }
        }
    }
}

