/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;

public class TermVectorsRequest
extends SingleShardRequest<TermVectorsRequest>
implements RealtimeRequest {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TermVectorsRequest.class);
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final ParseField OFFSETS = new ParseField("offsets", new String[0]);
    private static final ParseField POSITIONS = new ParseField("positions", new String[0]);
    private static final ParseField PAYLOADS = new ParseField("payloads", new String[0]);
    private static final ParseField DFS = new ParseField("dfs", new String[0]);
    private static final ParseField FILTER = new ParseField("filter", new String[0]);
    private static final ParseField DOC = new ParseField("doc", new String[0]);
    private String type;
    private String id;
    private BytesReference doc;
    private XContentType xContentType;
    private String routing;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;
    protected String preference;
    private static final AtomicInteger randomInt = new AtomicInteger(0);
    private Set<String> selectedFields;
    private boolean realtime = true;
    private Map<String, String> perFieldAnalyzer;
    private FilterSettings filterSettings;
    private EnumSet<Flag> flagsEnum = EnumSet.of(Flag.Positions, Flag.Offsets, Flag.Payloads, Flag.FieldStatistics);

    public TermVectorsRequest() {
    }

    TermVectorsRequest(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
        if (in.readBoolean()) {
            this.doc = in.readBytesReference();
            this.xContentType = in.readEnum(XContentType.class);
        }
        this.routing = in.readOptionalString();
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalString();
        }
        this.preference = in.readOptionalString();
        long flags = in.readVLong();
        this.flagsEnum.clear();
        for (Flag flag : Flag.values()) {
            if ((flags & (long)(1 << flag.ordinal())) == 0L) continue;
            this.flagsEnum.add(flag);
        }
        int numSelectedFields = in.readVInt();
        if (numSelectedFields > 0) {
            this.selectedFields = new HashSet<String>();
            for (int i = 0; i < numSelectedFields; ++i) {
                this.selectedFields.add(in.readString());
            }
        }
        if (in.readBoolean()) {
            this.perFieldAnalyzer = TermVectorsRequest.readPerFieldAnalyzer(in.readMap());
        }
        if (in.readBoolean()) {
            this.filterSettings = new FilterSettings();
            this.filterSettings.readFrom(in);
        }
        this.realtime = in.readBoolean();
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = in.readLong();
    }

    public TermVectorsRequest(String index, String type, String id) {
        super(index);
        this.id = id;
        this.type = type;
    }

    public TermVectorsRequest(TermVectorsRequest other) {
        super(other.index());
        this.id = other.id();
        this.type = other.type();
        if (other.doc != null) {
            this.doc = new BytesArray(other.doc().toBytesRef(), true);
            this.xContentType = other.xContentType;
        }
        this.flagsEnum = other.getFlags().clone();
        this.preference = other.preference();
        this.routing = other.routing();
        if (other.selectedFields != null) {
            this.selectedFields = new HashSet<String>(other.selectedFields);
        }
        if (other.perFieldAnalyzer != null) {
            this.perFieldAnalyzer = new HashMap<String, String>(other.perFieldAnalyzer);
        }
        this.realtime = other.realtime();
        this.version = other.version();
        this.versionType = VersionType.fromValue(other.versionType().getValue());
        this.filterSettings = other.filterSettings();
    }

    public TermVectorsRequest(MultiGetRequest.Item item) {
        super(item.index());
        this.id = item.id();
        this.type = item.type();
        this.selectedFields(item.storedFields());
        this.routing(item.routing());
    }

    public EnumSet<Flag> getFlags() {
        return this.flagsEnum;
    }

    public TermVectorsRequest type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public TermVectorsRequest id(String id) {
        this.id = id;
        return this;
    }

    public BytesReference doc() {
        return this.doc;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public TermVectorsRequest doc(XContentBuilder documentBuilder) {
        return this.doc(BytesReference.bytes(documentBuilder), true, documentBuilder.contentType());
    }

    @Deprecated
    public TermVectorsRequest doc(BytesReference doc, boolean generateRandomId) {
        return this.doc(doc, generateRandomId, XContentHelper.xContentType(doc));
    }

    public TermVectorsRequest doc(BytesReference doc, boolean generateRandomId, XContentType xContentType) {
        if (generateRandomId) {
            this.id(String.valueOf(randomInt.getAndAdd(1)));
        }
        this.doc = doc;
        this.xContentType = xContentType;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public TermVectorsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public TermVectorsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public TermVectorsRequest offsets(boolean offsets) {
        this.setFlag(Flag.Offsets, offsets);
        return this;
    }

    public boolean offsets() {
        return this.flagsEnum.contains((Object)Flag.Offsets);
    }

    public TermVectorsRequest positions(boolean positions) {
        this.setFlag(Flag.Positions, positions);
        return this;
    }

    public boolean positions() {
        return this.flagsEnum.contains((Object)Flag.Positions);
    }

    public boolean payloads() {
        return this.flagsEnum.contains((Object)Flag.Payloads);
    }

    public TermVectorsRequest payloads(boolean payloads) {
        this.setFlag(Flag.Payloads, payloads);
        return this;
    }

    public boolean termStatistics() {
        return this.flagsEnum.contains((Object)Flag.TermStatistics);
    }

    public TermVectorsRequest termStatistics(boolean termStatistics) {
        this.setFlag(Flag.TermStatistics, termStatistics);
        return this;
    }

    public boolean fieldStatistics() {
        return this.flagsEnum.contains((Object)Flag.FieldStatistics);
    }

    public TermVectorsRequest fieldStatistics(boolean fieldStatistics) {
        this.setFlag(Flag.FieldStatistics, fieldStatistics);
        return this;
    }

    public Set<String> selectedFields() {
        return this.selectedFields;
    }

    public TermVectorsRequest selectedFields(String ... fields) {
        this.selectedFields = fields != null && fields.length != 0 ? Sets.newHashSet(fields) : null;
        return this;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public TermVectorsRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    public TermVectorsRequest perFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
        this.perFieldAnalyzer = perFieldAnalyzer != null && perFieldAnalyzer.size() != 0 ? new HashMap<String, String>(perFieldAnalyzer) : null;
        return this;
    }

    public FilterSettings filterSettings() {
        return this.filterSettings;
    }

    public TermVectorsRequest filterSettings(FilterSettings settings) {
        this.filterSettings = settings;
        return this;
    }

    public long version() {
        return this.version;
    }

    public TermVectorsRequest version(long version) {
        this.version = version;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    public TermVectorsRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    private void setFlag(Flag flag, boolean set) {
        if (set && !this.flagsEnum.contains((Object)flag)) {
            this.flagsEnum.add(flag);
        } else if (!set) {
            this.flagsEnum.remove((Object)flag);
            assert (!this.flagsEnum.contains((Object)flag));
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null && this.doc == null) {
            validationException = ValidateActions.addValidationError("id or doc is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.doc != null);
        if (this.doc != null) {
            out.writeBytesReference(this.doc);
            out.writeEnum(this.xContentType);
        }
        out.writeOptionalString(this.routing);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.preference);
        long longFlags = 0L;
        for (Flag flag : this.flagsEnum) {
            longFlags |= (long)(1 << flag.ordinal());
        }
        out.writeVLong(longFlags);
        if (this.selectedFields != null) {
            out.writeStringCollection(this.selectedFields);
        } else {
            out.writeVInt(0);
        }
        out.writeBoolean(this.perFieldAnalyzer != null);
        if (this.perFieldAnalyzer != null) {
            out.writeGenericValue(this.perFieldAnalyzer);
        }
        out.writeBoolean(this.filterSettings != null);
        if (this.filterSettings != null) {
            this.filterSettings.writeTo(out);
        }
        out.writeBoolean(this.realtime);
        out.writeByte(this.versionType.getValue());
        out.writeLong(this.version);
    }

    public static void parseRequest(TermVectorsRequest termVectorsRequest, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        ArrayList<String> fields = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) continue;
            if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse term vectors request. field [fields] must be an array", new Object[0]);
            }
            if (OFFSETS.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.offsets(parser.booleanValue());
                continue;
            }
            if (POSITIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.positions(parser.booleanValue());
                continue;
            }
            if (PAYLOADS.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.payloads(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("term_statistics") || currentFieldName.equals("termStatistics")) {
                termVectorsRequest.termStatistics(parser.booleanValue());
                continue;
            }
            if (currentFieldName.equals("field_statistics") || currentFieldName.equals("fieldStatistics")) {
                termVectorsRequest.fieldStatistics(parser.booleanValue());
                continue;
            }
            if (DFS.match(currentFieldName, parser.getDeprecationHandler())) {
                throw new IllegalArgumentException("distributed frequencies is not supported anymore for term vectors");
            }
            if (currentFieldName.equals("per_field_analyzer") || currentFieldName.equals("perFieldAnalyzer")) {
                termVectorsRequest.perFieldAnalyzer(TermVectorsRequest.readPerFieldAnalyzer(parser.map()));
                continue;
            }
            if (FILTER.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.filterSettings(TermVectorsRequest.readFilterSettings(parser));
                continue;
            }
            if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.index = parser.text();
                continue;
            }
            if (TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.type = parser.text();
                deprecationLogger.deprecate("termvectors_with_types", "[types removal] Specifying types in term vector requests is deprecated.", new Object[0]);
                continue;
            }
            if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                if (termVectorsRequest.doc != null) {
                    throw new ElasticsearchParseException("failed to parse term vectors request. either [id] or [doc] can be specified, but not both!", new Object[0]);
                }
                termVectorsRequest.id = parser.text();
                continue;
            }
            if (DOC.match(currentFieldName, parser.getDeprecationHandler())) {
                if (termVectorsRequest.id != null) {
                    throw new ElasticsearchParseException("failed to parse term vectors request. either [id] or [doc] can be specified, but not both!", new Object[0]);
                }
                termVectorsRequest.doc(XContentFactory.jsonBuilder().copyCurrentStructure(parser));
                continue;
            }
            if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.routing = parser.text();
                continue;
            }
            if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.version = parser.longValue();
                continue;
            }
            if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                termVectorsRequest.versionType = VersionType.fromString(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("failed to parse term vectors request. unknown field [{}]", currentFieldName);
        }
        if (fields.size() > 0) {
            String[] fieldsAsArray = new String[fields.size()];
            termVectorsRequest.selectedFields(fields.toArray(fieldsAsArray));
        }
    }

    public static Map<String, String> readPerFieldAnalyzer(Map<String, Object> map) {
        HashMap<String, String> mapStrStr = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() instanceof String) {
                mapStrStr.put(e.getKey(), (String)e.getValue());
                continue;
            }
            throw new ElasticsearchParseException("expecting the analyzer at [{}] to be a String, but found [{}] instead", e.getKey(), e.getValue().getClass());
        }
        return mapStrStr;
    }

    private static FilterSettings readFilterSettings(XContentParser parser) throws IOException {
        XContentParser.Token token;
        FilterSettings settings = new FilterSettings();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) continue;
            if (currentFieldName.equals("max_num_terms")) {
                settings.maxNumTerms = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("min_term_freq")) {
                settings.minTermFreq = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("max_term_freq")) {
                settings.maxTermFreq = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("min_doc_freq")) {
                settings.minDocFreq = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("max_doc_freq")) {
                settings.maxDocFreq = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("min_word_length")) {
                settings.minWordLength = parser.intValue();
                continue;
            }
            if (currentFieldName.equals("max_word_length")) {
                settings.maxWordLength = parser.intValue();
                continue;
            }
            throw new ElasticsearchParseException("failed to parse term vectors request. the field [{}] is not valid for filter parameter for term vector request", currentFieldName);
        }
        return settings;
    }

    public static enum Flag {
        Positions,
        Offsets,
        Payloads,
        FieldStatistics,
        TermStatistics;

    }

    public static final class FilterSettings {
        public Integer maxNumTerms;
        public Integer minTermFreq;
        public Integer maxTermFreq;
        public Integer minDocFreq;
        public Integer maxDocFreq;
        public Integer minWordLength;
        public Integer maxWordLength;

        public FilterSettings() {
        }

        public FilterSettings(@Nullable Integer maxNumTerms, @Nullable Integer minTermFreq, @Nullable Integer maxTermFreq, @Nullable Integer minDocFreq, @Nullable Integer maxDocFreq, @Nullable Integer minWordLength, @Nullable Integer maxWordLength) {
            this.maxNumTerms = maxNumTerms;
            this.minTermFreq = minTermFreq;
            this.maxTermFreq = maxTermFreq;
            this.minDocFreq = minDocFreq;
            this.maxDocFreq = maxDocFreq;
            this.minWordLength = minWordLength;
            this.maxWordLength = maxWordLength;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.maxNumTerms = in.readOptionalVInt();
            this.minTermFreq = in.readOptionalVInt();
            this.maxTermFreq = in.readOptionalVInt();
            this.minDocFreq = in.readOptionalVInt();
            this.maxDocFreq = in.readOptionalVInt();
            this.minWordLength = in.readOptionalVInt();
            this.maxWordLength = in.readOptionalVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVInt(this.maxNumTerms);
            out.writeOptionalVInt(this.minTermFreq);
            out.writeOptionalVInt(this.maxTermFreq);
            out.writeOptionalVInt(this.minDocFreq);
            out.writeOptionalVInt(this.maxDocFreq);
            out.writeOptionalVInt(this.minWordLength);
            out.writeOptionalVInt(this.maxWordLength);
        }
    }
}

