/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.unit.TimeValue;

public abstract class SingleObjectCache<T> {
    private volatile T cached;
    private Lock refreshLock = new ReentrantLock();
    private final TimeValue refreshInterval;
    protected long lastRefreshTimestamp = 0L;

    protected SingleObjectCache(TimeValue refreshInterval, T initialValue) {
        if (initialValue == null) {
            throw new IllegalArgumentException("initialValue must not be null");
        }
        this.refreshInterval = refreshInterval;
        this.cached = initialValue;
    }

    public T getOrRefresh() {
        if (this.needsRefresh() && this.refreshLock.tryLock()) {
            try {
                if (this.needsRefresh()) {
                    this.cached = this.refresh();
                    assert (this.cached != null);
                    this.lastRefreshTimestamp = System.currentTimeMillis();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        assert (this.cached != null);
        return this.cached;
    }

    protected final T getNoRefresh() {
        return this.cached;
    }

    protected abstract T refresh();

    protected boolean needsRefresh() {
        if (this.refreshInterval.millis() == 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastRefreshTimestamp > this.refreshInterval.millis();
    }
}

