/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;

public final class MappingLookup
implements Iterable<Mapper> {
    private final Map<String, Mapper> fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNested;
    private final FieldTypeLookup fieldTypeLookup;
    private final int metadataFieldCount;
    private final FieldNameAnalyzer indexAnalyzer;

    private static void put(Map<String, Analyzer> analyzers, String key, Analyzer value, Analyzer defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        analyzers.put(key, value);
    }

    public static MappingLookup fromMapping(Mapping mapping, Analyzer defaultIndex) {
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        for (MetadataFieldMapper metadataMapper : mapping.metadataMappers) {
            if (metadataMapper == null) continue;
            newFieldMappers.add(metadataMapper);
        }
        MappingLookup.collect(mapping.root, newObjectMappers, newFieldMappers, newFieldAliasMappers);
        return new MappingLookup(newFieldMappers, newObjectMappers, newFieldAliasMappers, mapping.metadataMappers.length, defaultIndex);
    }

    private static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        if (!(mapper instanceof RootObjectMapper)) {
            if (mapper instanceof ObjectMapper) {
                objectMappers.add((ObjectMapper)mapper);
            } else if (mapper instanceof FieldMapper) {
                fieldMappers.add((FieldMapper)mapper);
            } else if (mapper instanceof FieldAliasMapper) {
                fieldAliasMappers.add((FieldAliasMapper)mapper);
            } else {
                throw new IllegalStateException("Unrecognized mapper type [" + mapper.getClass().getSimpleName() + "].");
            }
        }
        for (Mapper child : mapper) {
            MappingLookup.collect(child, objectMappers, fieldMappers, fieldAliasMappers);
        }
    }

    public MappingLookup(Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers, Collection<FieldAliasMapper> aliasMappers, int metadataFieldCount, Analyzer defaultIndex) {
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, Analyzer> indexAnalyzers = new HashMap<String, Analyzer>();
        HashMap<String, ObjectMapper> objects = new HashMap<String, ObjectMapper>();
        boolean hasNested = false;
        for (ObjectMapper objectMapper : objectMappers) {
            if (objects.put(objectMapper.fullPath(), objectMapper) != null) {
                throw new MapperParsingException("Object mapper [" + objectMapper.fullPath() + "] is defined more than once");
            }
            if (!objectMapper.nested().isNested()) continue;
            hasNested = true;
        }
        this.hasNested = hasNested;
        for (FieldMapper fieldMapper : mappers) {
            if (objects.containsKey(fieldMapper.name())) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined both as an object and a field");
            }
            if (fieldMappers.put(fieldMapper.name(), fieldMapper) != null) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined more than once");
            }
            MappedFieldType fieldType = fieldMapper.fieldType();
            MappingLookup.put(indexAnalyzers, fieldType.name(), (Analyzer)fieldType.indexAnalyzer(), defaultIndex);
        }
        this.metadataFieldCount = metadataFieldCount;
        for (FieldAliasMapper fieldAliasMapper : aliasMappers) {
            if (objects.containsKey(fieldAliasMapper.name())) {
                throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an object and an alias");
            }
            if (fieldMappers.put(fieldAliasMapper.name(), fieldAliasMapper) == null) continue;
            throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an alias and a concrete field");
        }
        this.fieldTypeLookup = new FieldTypeLookup(mappers, aliasMappers);
        this.fieldMappers = Collections.unmodifiableMap(fieldMappers);
        this.indexAnalyzer = new FieldNameAnalyzer(indexAnalyzers);
        this.objectMappers = Collections.unmodifiableMap(objects);
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    public FieldTypeLookup fieldTypes() {
        return this.fieldTypeLookup;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.fieldMappers.values().iterator();
    }

    public void checkLimits(IndexSettings settings) {
        this.checkFieldLimit(settings.getMappingTotalFieldsLimit());
        this.checkObjectDepthLimit(settings.getMappingDepthLimit());
        this.checkFieldNameLengthLimit(settings.getMappingFieldNameLengthLimit());
        this.checkNestedLimit(settings.getMappingNestedFieldsLimit());
    }

    private void checkFieldLimit(long limit) {
        if ((long)(this.fieldMappers.size() + this.objectMappers.size() - this.metadataFieldCount) > limit) {
            throw new IllegalArgumentException("Limit of total fields [" + limit + "] has been exceeded");
        }
    }

    private void checkObjectDepthLimit(long limit) {
        for (String objectPath : this.objectMappers.keySet()) {
            int numDots = 0;
            for (int i = 0; i < objectPath.length(); ++i) {
                if (objectPath.charAt(i) != '.') continue;
                ++numDots;
            }
            int depth = numDots + 2;
            if ((long)depth <= limit) continue;
            throw new IllegalArgumentException("Limit of mapping depth [" + limit + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkFieldNameLengthLimit(long limit) {
        Stream.of(this.objectMappers.values().stream(), this.fieldMappers.values().stream()).reduce(Stream::concat).orElseGet(Stream::empty).forEach(mapper -> {
            String name = mapper.simpleName();
            if ((long)name.length() > limit) {
                throw new IllegalArgumentException("Field name [" + name + "] is longer than the limit of [" + limit + "] characters");
            }
        });
    }

    private void checkNestedLimit(long limit) {
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : this.objectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > limit) {
            throw new IllegalArgumentException("Limit of nested fields [" + limit + "] has been exceeded");
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public boolean isMultiField(String field) {
        String sourceParent = MappingLookup.parentObject(field);
        return sourceParent != null && this.fieldMappers.containsKey(sourceParent);
    }

    public boolean isObjectField(String field) {
        return this.objectMappers.containsKey(field);
    }

    public String getNestedScope(String path) {
        String parentPath = MappingLookup.parentObject(path);
        while (parentPath != null) {
            ObjectMapper objectMapper = this.objectMappers.get(parentPath);
            if (objectMapper != null && objectMapper.nested().isNested()) {
                return parentPath;
            }
            parentPath = MappingLookup.parentObject(parentPath);
        }
        return null;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

