/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BlockReconstructionWork {
    public static final Logger LOG = LoggerFactory.getLogger(BlockReconstructionWork.class);
    private final BlockInfo block;
    private final String srcPath;
    private final long blockSize;
    private final byte storagePolicyID;
    private final DatanodeDescriptor[] srcNodes;
    private final List<DatanodeDescriptor> containingNodes;
    private final List<DatanodeStorageInfo> liveReplicaStorages;
    private final int additionalReplRequired;
    private DatanodeStorageInfo[] targets;
    private final int priority;
    private boolean notEnoughRack = false;

    public BlockReconstructionWork(BlockInfo block, BlockCollection bc, DatanodeDescriptor[] srcNodes, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority) {
        this.block = block;
        this.srcPath = bc.getName();
        this.blockSize = block.getNumBytes();
        this.storagePolicyID = bc.getStoragePolicyID();
        this.srcNodes = srcNodes;
        this.containingNodes = containingNodes;
        this.liveReplicaStorages = liveReplicaStorages;
        this.additionalReplRequired = additionalReplRequired;
        this.priority = priority;
        this.targets = null;
    }

    DatanodeStorageInfo[] getTargets() {
        return this.targets;
    }

    void resetTargets() {
        this.targets = null;
    }

    void setTargets(DatanodeStorageInfo[] targets) {
        this.targets = targets;
    }

    List<DatanodeDescriptor> getContainingNodes() {
        return Collections.unmodifiableList(this.containingNodes);
    }

    public int getPriority() {
        return this.priority;
    }

    public BlockInfo getBlock() {
        return this.block;
    }

    public DatanodeDescriptor[] getSrcNodes() {
        return this.srcNodes;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public byte getStoragePolicyID() {
        return this.storagePolicyID;
    }

    List<DatanodeStorageInfo> getLiveReplicaStorages() {
        return this.liveReplicaStorages;
    }

    public int getAdditionalReplRequired() {
        return this.additionalReplRequired;
    }

    void setNotEnoughRack() {
        this.notEnoughRack = true;
    }

    boolean hasNotEnoughRack() {
        return this.notEnoughRack;
    }

    abstract void chooseTargets(BlockPlacementPolicy var1, BlockStoragePolicySuite var2, Set<Node> var3);

    abstract void addTaskToDatanode(NumberReplicas var1);
}

