/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.elasticsearch.client.ml.inference.TrainedModelDefinition;
import org.elasticsearch.client.ml.inference.TrainedModelInput;
import org.elasticsearch.client.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelConfig
implements ToXContentObject {
    public static final String NAME = "trained_model_config";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField CREATED_BY = new ParseField("created_by", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField COMPRESSED_DEFINITION = new ParseField("compressed_definition", new String[0]);
    public static final ParseField TAGS = new ParseField("tags", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField INPUT = new ParseField("input", new String[0]);
    public static final ParseField ESTIMATED_HEAP_MEMORY_USAGE_BYTES = new ParseField("estimated_heap_memory_usage_bytes", new String[0]);
    public static final ParseField ESTIMATED_OPERATIONS = new ParseField("estimated_operations", new String[0]);
    public static final ParseField LICENSE_LEVEL = new ParseField("license_level", new String[0]);
    public static final ParseField DEFAULT_FIELD_MAP = new ParseField("default_field_map", new String[0]);
    public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("trained_model_config", true, Builder::new);
    private final String modelId;
    private final String createdBy;
    private final Version version;
    private final String description;
    private final Instant createTime;
    private final TrainedModelDefinition definition;
    private final String compressedDefinition;
    private final List<String> tags;
    private final Map<String, Object> metadata;
    private final TrainedModelInput input;
    private final Long estimatedHeapMemory;
    private final Long estimatedOperations;
    private final String licenseLevel;
    private final Map<String, String> defaultFieldMap;
    private final InferenceConfig inferenceConfig;

    public static TrainedModelConfig fromXContent(XContentParser parser) throws IOException {
        return ((Builder)PARSER.parse(parser, null)).build();
    }

    TrainedModelConfig(String modelId, String createdBy, Version version, String description, Instant createTime, TrainedModelDefinition definition, String compressedDefinition, List<String> tags, Map<String, Object> metadata, TrainedModelInput input, Long estimatedHeapMemory, Long estimatedOperations, String licenseLevel, Map<String, String> defaultFieldMap, InferenceConfig inferenceConfig) {
        this.modelId = modelId;
        this.createdBy = createdBy;
        this.version = version;
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.definition = definition;
        this.compressedDefinition = compressedDefinition;
        this.description = description;
        this.tags = tags == null ? null : Collections.unmodifiableList(tags);
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.input = input;
        this.estimatedHeapMemory = estimatedHeapMemory;
        this.estimatedOperations = estimatedOperations;
        this.licenseLevel = licenseLevel;
        this.defaultFieldMap = defaultFieldMap == null ? null : Collections.unmodifiableMap(defaultFieldMap);
        this.inferenceConfig = inferenceConfig;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public TrainedModelDefinition getDefinition() {
        return this.definition;
    }

    public String getCompressedDefinition() {
        return this.compressedDefinition;
    }

    public TrainedModelInput getInput() {
        return this.input;
    }

    public ByteSizeValue getEstimatedHeapMemory() {
        return this.estimatedHeapMemory == null ? null : new ByteSizeValue(this.estimatedHeapMemory.longValue());
    }

    public Long getEstimatedHeapMemoryBytes() {
        return this.estimatedHeapMemory;
    }

    public Long getEstimatedOperations() {
        return this.estimatedOperations;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public Map<String, String> getDefaultFieldMap() {
        return this.defaultFieldMap;
    }

    public InferenceConfig getInferenceConfig() {
        return this.inferenceConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
        }
        if (this.createdBy != null) {
            builder.field(CREATED_BY.getPreferredName(), this.createdBy);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version.toString());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        if (this.definition != null) {
            builder.field(DEFINITION.getPreferredName(), (ToXContent)this.definition);
        }
        if (this.tags != null) {
            builder.field(TAGS.getPreferredName(), this.tags);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.input != null) {
            builder.field(INPUT.getPreferredName(), (ToXContent)this.input);
        }
        if (this.estimatedHeapMemory != null) {
            builder.field(ESTIMATED_HEAP_MEMORY_USAGE_BYTES.getPreferredName(), this.estimatedHeapMemory);
        }
        if (this.estimatedOperations != null) {
            builder.field(ESTIMATED_OPERATIONS.getPreferredName(), this.estimatedOperations);
        }
        if (this.compressedDefinition != null) {
            builder.field(COMPRESSED_DEFINITION.getPreferredName(), this.compressedDefinition);
        }
        if (this.licenseLevel != null) {
            builder.field(LICENSE_LEVEL.getPreferredName(), this.licenseLevel);
        }
        if (this.defaultFieldMap != null) {
            builder.field(DEFAULT_FIELD_MAP.getPreferredName(), this.defaultFieldMap);
        }
        if (this.inferenceConfig != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, INFERENCE_CONFIG.getPreferredName(), this.inferenceConfig);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelConfig that = (TrainedModelConfig)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.definition, that.definition) && Objects.equals(this.compressedDefinition, that.compressedDefinition) && Objects.equals(this.tags, that.tags) && Objects.equals(this.input, that.input) && Objects.equals(this.estimatedHeapMemory, that.estimatedHeapMemory) && Objects.equals(this.estimatedOperations, that.estimatedOperations) && Objects.equals(this.licenseLevel, that.licenseLevel) && Objects.equals(this.defaultFieldMap, that.defaultFieldMap) && Objects.equals(this.inferenceConfig, that.inferenceConfig) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.createdBy, this.version, this.createTime, this.definition, this.compressedDefinition, this.description, this.tags, this.estimatedHeapMemory, this.estimatedOperations, this.metadata, this.licenseLevel, this.input, this.inferenceConfig, this.defaultFieldMap);
    }

    static {
        PARSER.declareString(Builder::setModelId, MODEL_ID);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setCreatedBy(x$0), CREATED_BY);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setVersion(x$0), VERSION);
        PARSER.declareString(Builder::setDescription, DESCRIPTION);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setCreateTime(x$0), (p, c) -> TimeUtil.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(Builder::setDefinition, (p, c) -> TrainedModelDefinition.fromXContent(p), DEFINITION);
        PARSER.declareString(Builder::setCompressedDefinition, COMPRESSED_DEFINITION);
        PARSER.declareStringArray(Builder::setTags, TAGS);
        PARSER.declareObject(Builder::setMetadata, (p, c) -> p.map(), METADATA);
        PARSER.declareObject(Builder::setInput, (p, c) -> TrainedModelInput.fromXContent(p), INPUT);
        PARSER.declareLong((rec$, x$0) -> ((Builder)rec$).setEstimatedHeapMemory(x$0), ESTIMATED_HEAP_MEMORY_USAGE_BYTES);
        PARSER.declareLong((rec$, x$0) -> ((Builder)rec$).setEstimatedOperations(x$0), ESTIMATED_OPERATIONS);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLicenseLevel(x$0), LICENSE_LEVEL);
        PARSER.declareObject(Builder::setDefaultFieldMap, (p, c) -> p.mapStrings(), DEFAULT_FIELD_MAP);
        PARSER.declareNamedObject(Builder::setInferenceConfig, (p, c, n) -> (InferenceConfig)p.namedObject(InferenceConfig.class, n, null), INFERENCE_CONFIG);
    }

    public static class Builder {
        private String modelId;
        private String createdBy;
        private Version version;
        private String description;
        private Instant createTime;
        private Map<String, Object> metadata;
        private List<String> tags;
        private TrainedModelDefinition definition;
        private String compressedDefinition;
        private TrainedModelInput input;
        private Long estimatedHeapMemory;
        private Long estimatedOperations;
        private String licenseLevel;
        private Map<String, String> defaultFieldMap;
        private InferenceConfig inferenceConfig;

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        private Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        private Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        private Builder setVersion(String version) {
            return this.setVersion(Version.fromString((String)version));
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        private Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder setTags(String ... tags) {
            return this.setTags(Arrays.asList(tags));
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDefinition(TrainedModelDefinition.Builder definition) {
            this.definition = definition == null ? null : definition.build();
            return this;
        }

        public Builder setCompressedDefinition(String compressedDefinition) {
            this.compressedDefinition = compressedDefinition;
            return this;
        }

        public Builder setDefinition(TrainedModelDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder setInput(TrainedModelInput input) {
            this.input = input;
            return this;
        }

        private Builder setEstimatedHeapMemory(Long estimatedHeapMemory) {
            this.estimatedHeapMemory = estimatedHeapMemory;
            return this;
        }

        private Builder setEstimatedOperations(Long estimatedOperations) {
            this.estimatedOperations = estimatedOperations;
            return this;
        }

        private Builder setLicenseLevel(String licenseLevel) {
            this.licenseLevel = licenseLevel;
            return this;
        }

        public Builder setDefaultFieldMap(Map<String, String> defaultFieldMap) {
            this.defaultFieldMap = defaultFieldMap;
            return this;
        }

        public Builder setInferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public TrainedModelConfig build() {
            return new TrainedModelConfig(this.modelId, this.createdBy, this.version, this.description, this.createTime, this.definition, this.compressedDefinition, this.tags, this.metadata, this.input, this.estimatedHeapMemory, this.estimatedOperations, this.licenseLevel, this.defaultFieldMap, this.inferenceConfig);
        }
    }
}

