/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerServiceResourceMatcher;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerResourceEvaluatorsRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedResourceEvaluators {
    private final Map<String, Map<Map<String, RangerAccessRequest.ResourceElementMatchingScope>, Collection<RangerServiceResourceMatcher>>> cache = new HashMap<String, Map<Map<String, RangerAccessRequest.ResourceElementMatchingScope>, Collection<RangerServiceResourceMatcher>>>();
    private final RangerReadWriteLock cacheLock = new RangerReadWriteLock(true);
    private static final Logger LOG = LoggerFactory.getLogger(CachedResourceEvaluators.class);
    private static final Logger PERF_EVALUATORS_RETRIEVAL_LOG = RangerPerfTracer.getPerfLogger("CachedResourceEvaluators.retrieval");

    public Collection<RangerServiceResourceMatcher> getEvaluators(String resourceKey, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes) {
        Collection ret;
        try (RangerReadWriteLock.RangerLock ignored = this.cacheLock.getReadLock();){
            ret = (Collection)this.cache.getOrDefault(resourceKey, Collections.emptyMap()).get(scopes);
        }
        return ret;
    }

    public void cacheEvaluators(String resource, Map<String, RangerAccessRequest.ResourceElementMatchingScope> scopes, Collection<RangerServiceResourceMatcher> evaluators) {
        try (RangerReadWriteLock.RangerLock ignored = this.cacheLock.getWriteLock();){
            this.cache.computeIfAbsent(resource, k -> new HashMap()).put(scopes, evaluators);
        }
    }

    public void removeCacheEvaluators(Set<String> resources) {
        try (RangerReadWriteLock.RangerLock ignored = this.cacheLock.getWriteLock();){
            resources.forEach(this.cache::remove);
        }
    }

    public void clearCache() {
        try (RangerReadWriteLock.RangerLock ignored = this.cacheLock.getWriteLock();){
            this.cache.clear();
        }
    }

    public static Collection<RangerServiceResourceMatcher> getEvaluators(RangerAccessRequest request, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie, CachedResourceEvaluators cache) {
        SelfOrAncestorPredicate predicate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> CachedResourceEvaluators.getEvaluators(request=" + request + ")");
        }
        Collection<RangerServiceResourceMatcher> ret = null;
        RangerAccessResource resource = request.getResource();
        RangerServiceDefHelper helper = new RangerServiceDefHelper(resource.getServiceDef());
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_EVALUATORS_RETRIEVAL_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_EVALUATORS_RETRIEVAL_LOG, "CachedResourceEvaluators.getEvaluators(resource=" + resource.getAsString() + ")");
        }
        RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = request.getResourceMatchingScope() != null ? request.getResourceMatchingScope() : RangerAccessRequest.ResourceMatchingScope.SELF;
        SelfOrAncestorPredicate selfOrAncestorPredicate = predicate = !request.isAccessTypeAny() && resourceMatchingScope != RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS && CachedResourceEvaluators.excludeDescendantMatches(resource) ? new SelfOrAncestorPredicate(helper.getResourceDef(resource.getLeafName())) : null;
        if (predicate != null) {
            ret = cache.getEvaluators(resource.getCacheKey(), request.getResourceElementMatchingScopes());
        }
        if (ret == null) {
            ret = RangerResourceEvaluatorsRetriever.getEvaluators(serviceResourceTrie, resource.getAsMap(), request.getResourceElementMatchingScopes(), predicate);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found [" + ret.size() + "] service-resource-matchers for service-resource [" + resource.getAsString() + "]");
            }
            if (predicate != null) {
                cache.cacheEvaluators(resource.getCacheKey(), request.getResourceElementMatchingScopes(), ret);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Found [" + ret.size() + "] service-resource-matchers for service-resource [" + resource.getAsString() + "] in the cache");
        }
        RangerPerfTracer.logAlways(perf);
        if (ret == null) {
            ret = new ArrayList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== CachedResourceEvaluators.getEvaluators(request=" + request + "): evaluators=" + ret);
        }
        return ret;
    }

    public static boolean excludeDescendantMatches(RangerAccessResource resource) {
        List<RangerServiceDef.RangerResourceDef> theHierarchy;
        RangerServiceDef.RangerResourceDef leafOfHierarchy;
        RangerServiceDefHelper helper;
        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies;
        String leafName = resource.getLeafName();
        boolean ret = StringUtils.isNotEmpty((String)leafName) ? ((hierarchies = (helper = new RangerServiceDefHelper(resource.getServiceDef())).getResourceHierarchies(0, resource.getKeys())).size() == 1 ? !StringUtils.equals((String)(leafOfHierarchy = (theHierarchy = hierarchies.iterator().next()).get(theHierarchy.size() - 1)).getName(), (String)leafName) : true) : false;
        return ret;
    }

    private static class SelfOrAncestorPredicate
    implements Predicate {
        private final RangerServiceDef.RangerResourceDef leafResourceDef;

        public SelfOrAncestorPredicate(RangerServiceDef.RangerResourceDef leafResourceDef) {
            this.leafResourceDef = leafResourceDef;
        }

        public boolean evaluate(Object o) {
            if (o instanceof RangerResourceEvaluator) {
                RangerResourceEvaluator evaluator = (RangerResourceEvaluator)o;
                return evaluator.isLeaf(this.leafResourceDef.getName()) || evaluator.isAncestorOf(this.leafResourceDef);
            }
            return false;
        }
    }
}

