/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.FileServerCreateParameters;
import com.microsoft.azure.management.batchai.FileServersListByWorkspaceOptions;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.FileServerInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FileServersInner {
    private FileServersService service;
    private BatchAIManagementClientImpl client;

    public FileServersInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (FileServersService)retrofit.create(FileServersService.class);
        this.client = client;
    }

    public FileServerInner create(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        return (FileServerInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FileServerInner> createAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters), serviceCallback);
    }

    public Observable<FileServerInner> createAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, workspaceName, fileServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FileServerInner>(){}.getType());
    }

    public FileServerInner beginCreate(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        return (FileServerInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FileServerInner> beginCreateAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters), serviceCallback);
    }

    public Observable<FileServerInner> beginCreateAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName, parameters).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String fileServerName, FileServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, workspaceName, fileServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServerInner>>>(){

            public Observable<ServiceResponse<FileServerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServerInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServerInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String workspaceName, String fileServerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, String fileServerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, workspaceName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String workspaceName, String fileServerName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String fileServerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, workspaceName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileServerInner get(String resourceGroupName, String workspaceName, String fileServerName) {
        return (FileServerInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).toBlocking().single()).body());
    }

    public ServiceFuture<FileServerInner> getAsync(String resourceGroupName, String workspaceName, String fileServerName, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName), serviceCallback);
    }

    public Observable<FileServerInner> getAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        return this.getWithServiceResponseAsync(resourceGroupName, workspaceName, fileServerName).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> getWithServiceResponseAsync(String resourceGroupName, String workspaceName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, workspaceName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServerInner>>>(){

            public Observable<ServiceResponse<FileServerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServerInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> listByWorkspace(String resourceGroupName, String workspaceName) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileServersListByWorkspaceOptions = null;
        Integer maxResults = null;
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<FileServerInner> listByWorkspace(String resourceGroupName, String workspaceName, FileServersListByWorkspaceOptions fileServersListByWorkspaceOptions) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, fileServersListByWorkspaceOptions).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, FileServersListByWorkspaceOptions fileServersListByWorkspaceOptions, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, fileServersListByWorkspaceOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, FileServersListByWorkspaceOptions fileServersListByWorkspaceOptions) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName, fileServersListByWorkspaceOptions).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName, FileServersListByWorkspaceOptions fileServersListByWorkspaceOptions) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, fileServersListByWorkspaceOptions).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName, FileServersListByWorkspaceOptions fileServersListByWorkspaceOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileServersListByWorkspaceOptions);
        Integer maxResults = null;
        if (fileServersListByWorkspaceOptions != null) {
            maxResults = fileServersListByWorkspaceOptions.maxResults();
        }
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listByWorkspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> listByWorkspaceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByWorkspaceNextAsync(String nextPageLink, ServiceFuture<List<FileServerInner>> serviceFuture, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByWorkspaceNextAsync(String nextPageLink) {
        return this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByWorkspaceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByWorkspaceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByWorkspaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByWorkspaceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listByWorkspaceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FileServersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="fileServerName") String var3, @Path(value="subscriptionId") String var4, @Body FileServerCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="fileServerName") String var3, @Path(value="subscriptionId") String var4, @Body FileServerCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="fileServerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="fileServerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="fileServerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers listByWorkspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers")
        public Observable<Response<ResponseBody>> listByWorkspace(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers listByWorkspaceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByWorkspaceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

