/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ComputeUsage;
import com.microsoft.azure.management.compute.ComputeUsages;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeUsageImpl;
import com.microsoft.azure.management.compute.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import rx.Observable;

@LangDefinition
class ComputeUsagesImpl
extends ReadableWrappersImpl<ComputeUsage, ComputeUsageImpl, UsageInner>
implements ComputeUsages {
    private final ComputeManagementClientImpl client;

    ComputeUsagesImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public PagedList<ComputeUsage> listByRegion(Region region) {
        return this.listByRegion(region.name());
    }

    public PagedList<ComputeUsage> listByRegion(String regionName) {
        return this.wrapList(this.client.usages().list(regionName));
    }

    public Observable<ComputeUsage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public Observable<ComputeUsage> listByRegionAsync(String regionName) {
        return this.wrapPageAsync(this.client.usages().listAsync(regionName));
    }

    protected ComputeUsageImpl wrapModel(UsageInner usageInner) {
        if (usageInner == null) {
            return null;
        }
        return new ComputeUsageImpl(usageInner);
    }
}

