/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkPeering;
import com.microsoft.azure.management.network.NetworkPeerings;
import com.microsoft.azure.management.network.implementation.NetworkImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkPeeringImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkPeeringsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class NetworkPeeringsImpl
extends IndependentChildrenImpl<NetworkPeering, NetworkPeeringImpl, VirtualNetworkPeeringInner, VirtualNetworkPeeringsInner, NetworkManager, Network>
implements NetworkPeerings {
    private final NetworkImpl network;

    NetworkPeeringsImpl(NetworkImpl parent) {
        super((Object)((NetworkManagementClientImpl)((Object)((NetworkManager)parent.manager()).inner())).virtualNetworkPeerings(), parent.manager());
        this.network = parent;
    }

    public NetworkPeeringImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkPeeringImpl wrapModel(String name) {
        VirtualNetworkPeeringInner inner = new VirtualNetworkPeeringInner().withName(name);
        return new NetworkPeeringImpl(inner, this.network);
    }

    protected NetworkPeeringImpl wrapModel(VirtualNetworkPeeringInner inner) {
        return inner != null ? new NetworkPeeringImpl(inner, this.network) : null;
    }

    public Completable deleteByParentAsync(String groupName, String parentName, final String name) {
        return ((NetworkManager)this.manager()).networks().getByResourceGroupAsync(groupName, parentName).flatMap((Func1)new Func1<Network, Observable<NetworkPeering>>(){

            public Observable<NetworkPeering> call(Network localNetwork) {
                if (localNetwork == null) {
                    return Observable.just(null);
                }
                String peeringId = localNetwork.id() + "/peerings/" + name;
                return localNetwork.peerings().getByIdAsync(peeringId);
            }
        }).flatMap((Func1)new Func1<NetworkPeering, Observable<NetworkPeering>>(){

            public Observable<NetworkPeering> call(NetworkPeering localPeering) {
                if (localPeering == null) {
                    return Observable.just(null);
                }
                if (!localPeering.isSameSubscription()) {
                    return Observable.just((Object)localPeering);
                }
                return Observable.just((Object)localPeering).concatWith(localPeering.getRemotePeeringAsync());
            }
        }).flatMap((Func1)new Func1<NetworkPeering, Observable<Void>>(){

            public Observable<Void> call(NetworkPeering peering) {
                if (peering == null) {
                    return Observable.just(null);
                }
                String networkName = ResourceUtils.nameFromResourceId((String)peering.networkId());
                return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)peering.manager())).inner())).virtualNetworkPeerings().deleteAsync(peering.resourceGroupName(), networkName, peering.name());
            }
        }).last().toCompletable();
    }

    public Observable<NetworkPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((VirtualNetworkPeeringsInner)this.inner()).getAsync(resourceGroup, parentName, name).map((Func1)new Func1<VirtualNetworkPeeringInner, NetworkPeering>(){

            public NetworkPeering call(VirtualNetworkPeeringInner inner) {
                return NetworkPeeringsImpl.this.wrapModel(inner);
            }
        });
    }

    public PagedList<NetworkPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((VirtualNetworkPeeringsInner)this.inner()).list(resourceGroupName, parentName));
    }

    public PagedList<NetworkPeering> list() {
        return this.wrapList(((VirtualNetworkPeeringsInner)this.inner()).list(this.network.resourceGroupName(), this.network.name()));
    }

    public Observable<NetworkPeering> listAsync() {
        return this.wrapPageAsync(((VirtualNetworkPeeringsInner)this.inner()).listAsync(this.network.resourceGroupName(), this.network.name()));
    }

    @Override
    public NetworkPeering getByRemoteNetwork(Network network) {
        return network != null ? this.getByRemoteNetwork(network.id()) : null;
    }

    @Override
    public NetworkPeering getByRemoteNetwork(String remoteNetworkResourceId) {
        if (remoteNetworkResourceId != null) {
            for (NetworkPeering peering : this.list()) {
                if (!peering.remoteNetworkId().equalsIgnoreCase(remoteNetworkResourceId)) continue;
                return peering;
            }
        }
        return null;
    }

    @Override
    public Observable<NetworkPeering> getByRemoteNetworkAsync(Network network) {
        if (network != null) {
            return this.getByRemoteNetworkAsync(network.id());
        }
        return Observable.just(null);
    }

    @Override
    public Observable<NetworkPeering> getByRemoteNetworkAsync(final String remoteNetworkResourceId) {
        if (remoteNetworkResourceId == null) {
            return Observable.just(null);
        }
        return this.listAsync().filter((Func1)new Func1<NetworkPeering, Boolean>(){

            public Boolean call(NetworkPeering peering) {
                if (peering == null) {
                    return false;
                }
                return remoteNetworkResourceId.equalsIgnoreCase(peering.remoteNetworkId());
            }
        });
    }
}

