/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.dropwizard3;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.dropwizard3.Dm3RatisMetricRegistryImpl;
import org.apache.ratis.util.TimeDuration;

public interface Dm3JvmMetrics {
    public static void initJvmMetrics(TimeDuration consoleReportRate) {
        MetricRegistries registries = MetricRegistries.global();
        Dm3JvmMetrics.addJvmMetrics(registries);
        registries.enableConsoleReporter(consoleReportRate);
        registries.enableJmxReporter();
    }

    public static void addJvmMetrics(MetricRegistries registries) {
        MetricRegistryInfo info = new MetricRegistryInfo("jvm", "ratis_jvm", "jvm", "jvm metrics");
        RatisMetricRegistry registry = registries.create(info);
        Dm3RatisMetricRegistryImpl impl = Dm3RatisMetricRegistryImpl.cast(registry);
        impl.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        impl.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        impl.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        impl.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
    }
}

