/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.MetricRegistryFactoryImpl;
import org.apache.ratis.metrics.impl.MetricsReporting;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.util.RefCountingMap;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistriesImpl
extends MetricRegistries {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistriesImpl.class);
    private final List<Consumer<RatisMetricRegistry>> reporterRegistrations = new CopyOnWriteArrayList<Consumer<RatisMetricRegistry>>();
    private final List<Consumer<RatisMetricRegistry>> stopReporters = new CopyOnWriteArrayList<Consumer<RatisMetricRegistry>>();
    private final MetricRegistryFactoryImpl factory;
    private final RefCountingMap<MetricRegistryInfo, RatisMetricRegistry> registries;
    private final Object registerLock = new Object();

    public MetricRegistriesImpl() {
        this(new MetricRegistryFactoryImpl());
    }

    MetricRegistriesImpl(MetricRegistryFactoryImpl factory) {
        this.factory = factory;
        this.registries = new RefCountingMap();
    }

    @Override
    public RatisMetricRegistry create(MetricRegistryInfo info) {
        return this.registries.put(info, () -> {
            if (this.reporterRegistrations.isEmpty()) {
                Object object = this.registerLock;
                synchronized (object) {
                    if (this.reporterRegistrations.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("First MetricRegistry has been created without registering reporters. Hence registering JMX reporter by default.");
                        }
                        this.enableJmxReporter();
                    }
                }
            }
            RatisMetricRegistryImpl registry = this.factory.create(info);
            this.reporterRegistrations.forEach(reg -> reg.accept(registry));
            return registry;
        });
    }

    @Override
    public boolean remove(MetricRegistryInfo key) {
        RatisMetricRegistry registry = this.registries.get(key);
        if (registry != null) {
            this.stopReporters.forEach(reg -> reg.accept(registry));
        }
        return this.registries.remove(key) == null;
    }

    @Override
    public Optional<RatisMetricRegistry> get(MetricRegistryInfo info) {
        return Optional.ofNullable(this.registries.get(info));
    }

    @Override
    public Collection<RatisMetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    public void clear() {
        this.registries.clear();
    }

    @Override
    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }

    @Override
    public void addReporterRegistration(Consumer<RatisMetricRegistry> reporterRegistration, Consumer<RatisMetricRegistry> stopReporter) {
        if (this.registries.size() > 0) {
            LOG.warn("New reporters are added after registries were created. Some metrics will be missing from the reporter. Please add reporter before adding any new registry.");
        }
        this.reporterRegistrations.add(reporterRegistration);
        this.stopReporters.add(stopReporter);
    }

    @Override
    public void removeReporterRegistration(Consumer<RatisMetricRegistry> reporterRegistration, Consumer<RatisMetricRegistry> stopReporter) {
        this.reporterRegistrations.remove(reporterRegistration);
        this.stopReporters.remove(stopReporter);
    }

    @Override
    public void enableJmxReporter() {
        this.addReporterRegistration(MetricsReporting.jmxReporter(), MetricsReporting.stopJmxReporter());
    }

    @Override
    public void enableConsoleReporter(TimeDuration consoleReportRate) {
        this.addReporterRegistration(MetricsReporting.consoleReporter(consoleReportRate), MetricsReporting.stopConsoleReporter());
    }
}

