/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.Recyclable;
import com.alipay.sofa.jraft.util.Recyclers;
import com.alipay.sofa.jraft.util.Utils;
import java.nio.ByteBuffer;

public final class ByteBufferCollector
implements Recyclable {
    private static final int MAX_CAPACITY_TO_RECYCLE = 0x400000;
    private ByteBuffer buffer;
    private final transient Recyclers.Handle handle;
    private static final Recyclers<ByteBufferCollector> recyclers = new Recyclers<ByteBufferCollector>(Utils.MAX_COLLECTOR_SIZE_PER_THREAD){

        @Override
        protected ByteBufferCollector newObject(Recyclers.Handle handle) {
            return new ByteBufferCollector(0, handle);
        }
    };

    public int capacity() {
        return this.buffer != null ? this.buffer.capacity() : 0;
    }

    public void expandIfNecessary() {
        if (!this.hasRemaining()) {
            this.getBuffer(Utils.RAFT_DATA_BUF_SIZE);
        }
    }

    public void expandAtMost(int atMostBytes) {
        this.buffer = this.buffer == null ? Utils.allocate(atMostBytes) : Utils.expandByteBufferAtMost(this.buffer, atMostBytes);
    }

    public boolean hasRemaining() {
        return this.buffer != null && this.buffer.hasRemaining();
    }

    private ByteBufferCollector(int size, Recyclers.Handle handle) {
        if (size > 0) {
            this.buffer = Utils.allocate(size);
        }
        this.handle = handle;
    }

    public static ByteBufferCollector allocate(int size) {
        return new ByteBufferCollector(size, Recyclers.NOOP_HANDLE);
    }

    public static ByteBufferCollector allocate() {
        return ByteBufferCollector.allocate(Utils.RAFT_DATA_BUF_SIZE);
    }

    public static ByteBufferCollector allocateByRecyclers(int size) {
        ByteBufferCollector collector = recyclers.get();
        collector.reset(size);
        return collector;
    }

    public static ByteBufferCollector allocateByRecyclers() {
        return ByteBufferCollector.allocateByRecyclers(Utils.RAFT_DATA_BUF_SIZE);
    }

    public static int threadLocalCapacity() {
        return recyclers.threadLocalCapacity();
    }

    public static int threadLocalSize() {
        return recyclers.threadLocalSize();
    }

    private void reset(int expectSize) {
        if (this.buffer == null) {
            this.buffer = Utils.allocate(expectSize);
        } else if (this.buffer.capacity() < expectSize) {
            this.buffer = Utils.allocate(expectSize);
        }
    }

    private ByteBuffer getBuffer(int expectSize) {
        if (this.buffer == null) {
            this.buffer = Utils.allocate(expectSize);
        } else if (this.buffer.remaining() < expectSize) {
            this.buffer = Utils.expandByteBufferAtLeast(this.buffer, expectSize);
        }
        return this.buffer;
    }

    public void put(ByteBuffer buf) {
        this.getBuffer(buf.remaining()).put(buf);
    }

    public void put(byte[] bs) {
        this.getBuffer(bs.length).put(bs);
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean recycle() {
        if (this.buffer != null) {
            if (this.buffer.capacity() > 0x400000) {
                this.buffer = null;
            } else {
                BufferUtils.clear(this.buffer);
            }
        }
        return recyclers.recycle(this, this.handle);
    }
}

