/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.PluginIdentifierInterface;
import org.apache.seatunnel.apis.base.plugin.Plugin;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.utils.ReflectionUtils;
import org.apache.seatunnel.plugin.discovery.PluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginDiscovery<T>
implements PluginDiscovery<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginDiscovery.class);
    private final Path pluginDir;
    private BiConsumer<ClassLoader, URL> addURLToClassLoader = (classLoader, url) -> {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new UnsupportedOperationException("can't support custom load jar");
        }
        ReflectionUtils.invoke(classLoader, "addURL", url);
    };
    protected final ConcurrentHashMap<PluginIdentifier, Optional<URL>> pluginJarPath = new ConcurrentHashMap(16);

    public AbstractPluginDiscovery(String pluginSubDir, BiConsumer<ClassLoader, URL> addURLToClassloader) {
        this.pluginDir = Common.connectorJarDir(pluginSubDir);
        this.addURLToClassLoader = addURLToClassloader;
        LOGGER.info("Load {} Plugin from {}", (Object)this.getPluginBaseClass().getSimpleName(), (Object)this.pluginDir);
    }

    public AbstractPluginDiscovery(String pluginSubDir) {
        this.pluginDir = Common.connectorJarDir(pluginSubDir);
        LOGGER.info("Load {} Plugin from {}", (Object)this.getPluginBaseClass().getSimpleName(), (Object)this.pluginDir);
    }

    @Override
    public List<URL> getPluginJarPaths(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::getPluginJarPath).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    @Override
    public List<T> getAllPlugins(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::createPluginInstance).distinct().collect(Collectors.toList());
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        T pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
        if (pluginInstance != null) {
            LOGGER.info("Load plugin: {} from classpath", (Object)pluginIdentifier);
            return pluginInstance;
        }
        Optional<URL> pluginJarPath = this.getPluginJarPath(pluginIdentifier);
        if (pluginJarPath.isPresent()) {
            try {
                this.addURLToClassLoader.accept(classLoader, pluginJarPath.get());
            }
            catch (Exception e) {
                LOGGER.warn("can't load jar use current thread classloader, use URLClassLoader instead now. message: " + e.getMessage());
                classLoader = new URLClassLoader(new URL[]{pluginJarPath.get()}, Thread.currentThread().getContextClassLoader());
            }
            pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
            if (pluginInstance != null) {
                LOGGER.info("Load plugin: {} from path: {} use classloader: {}", pluginIdentifier, pluginJarPath.get(), classLoader.getClass().getName());
                return pluginInstance;
            }
        }
        throw new RuntimeException("Plugin " + pluginIdentifier + " not found.");
    }

    @Nullable
    private T loadPluginInstance(PluginIdentifier pluginIdentifier, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(this.getPluginBaseClass(), classLoader);
        for (T t : serviceLoader) {
            if (t instanceof Plugin) {
                Plugin pluginInstance = (Plugin)t;
                if (!StringUtils.equalsIgnoreCase(pluginInstance.getPluginName(), pluginIdentifier.getPluginName())) continue;
                return (T)pluginInstance;
            }
            if (t instanceof PluginIdentifierInterface) {
                PluginIdentifierInterface pluginIdentifierInstance = (PluginIdentifierInterface)t;
                if (!StringUtils.equalsIgnoreCase(pluginIdentifierInstance.getPluginName(), pluginIdentifier.getPluginName())) continue;
                return (T)pluginIdentifierInstance;
            }
            throw new UnsupportedOperationException("Plugin instance: " + t + " is not supported.");
        }
        return null;
    }

    protected Optional<URL> getPluginJarPath(PluginIdentifier pluginIdentifier) {
        return this.pluginJarPath.computeIfAbsent(pluginIdentifier, this::findPluginJarPath);
    }

    protected abstract Class<T> getPluginBaseClass();

    private Optional<URL> findPluginJarPath(PluginIdentifier pluginIdentifier) {
        if (PLUGIN_JAR_MAPPING.isEmpty()) {
            return Optional.empty();
        }
        String engineType = pluginIdentifier.getEngineType().toLowerCase();
        String pluginType = pluginIdentifier.getPluginType().toLowerCase();
        String pluginName = pluginIdentifier.getPluginName().toLowerCase();
        if (!PLUGIN_JAR_MAPPING.hasPath(engineType)) {
            return Optional.empty();
        }
        Config engineConfig = PLUGIN_JAR_MAPPING.getConfig(engineType);
        if (!engineConfig.hasPath(pluginType)) {
            return Optional.empty();
        }
        Config typeConfig = engineConfig.getConfig(pluginType);
        Optional<Map.Entry> optional = typeConfig.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), pluginName)).findFirst();
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        final String pluginJarPrefix = ((ConfigValue)optional.get().getValue()).unwrapped().toString();
        Object[] targetPluginFiles = this.pluginDir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && StringUtils.startsWithIgnoreCase(pathname.getName(), pluginJarPrefix);
            }
        });
        if (ArrayUtils.isEmpty(targetPluginFiles)) {
            return Optional.empty();
        }
        try {
            URL pluginJarPath = ((File)targetPluginFiles[0]).toURI().toURL();
            LOGGER.info("Discovery plugin jar: {} at: {}", (Object)pluginIdentifier.getPluginName(), (Object)pluginJarPath);
            return Optional.of(pluginJarPath);
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Cannot get plugin URL: " + targetPluginFiles[0], e);
            return Optional.empty();
        }
    }
}

