/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.serialization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;

public abstract class RowConverter<T> {
    protected final SeaTunnelDataType<?> dataType;

    public RowConverter(SeaTunnelDataType<?> dataType) {
        this.dataType = dataType;
    }

    public void validate(SeaTunnelRow seaTunnelRow) throws IOException {
        if (!(this.dataType instanceof SeaTunnelRowType)) {
            throw new UnsupportedOperationException(String.format("The data type don't support validation: %s. ", this.dataType.getClass().getSimpleName()));
        }
        SeaTunnelDataType<?>[] fieldTypes = ((SeaTunnelRowType)this.dataType).getFieldTypes();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < fieldTypes.length; ++i) {
            SeaTunnelDataType<?> fieldType;
            Object field2 = seaTunnelRow.getField(i);
            if (this.validate(field2, fieldType = fieldTypes[i])) continue;
            errors.add(String.format("The SQL type '%s' don't support '%s', the class of the expected data type is '%s'.", new Object[]{fieldType.getSqlType(), field2.getClass(), fieldType.getTypeClass()}));
        }
        if (errors.size() > 0) {
            throw new UnsupportedOperationException(String.join((CharSequence)",", errors));
        }
    }

    protected boolean validate(Object field2, SeaTunnelDataType<?> dataType) {
        if (field2 == null || dataType.getSqlType() == SqlType.NULL) {
            return true;
        }
        SqlType sqlType = dataType.getSqlType();
        switch (sqlType) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DECIMAL: 
            case BYTES: 
            case ARRAY: {
                return dataType.getTypeClass() == field2.getClass();
            }
            case MAP: {
                if (!(field2 instanceof Map)) {
                    return false;
                }
                MapType mapType = (MapType)dataType;
                Map mapField = (Map)field2;
                if (mapField.size() == 0) {
                    return true;
                }
                Map.Entry entry = (Map.Entry)mapField.entrySet().stream().findFirst().get();
                return this.validate(entry.getKey(), mapType.getKeyType()) && this.validate(entry.getValue(), mapType.getValueType());
            }
            case ROW: {
                if (!(field2 instanceof SeaTunnelRow)) {
                    return false;
                }
                SeaTunnelDataType<?>[] fieldTypes = ((SeaTunnelRowType)dataType).getFieldTypes();
                SeaTunnelRow seaTunnelRow = (SeaTunnelRow)field2;
                for (int i = 0; i < fieldTypes.length; ++i) {
                    if (this.validate(seaTunnelRow.getField(i), fieldTypes[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public abstract T convert(SeaTunnelRow var1) throws IOException;

    public abstract SeaTunnelRow reconvert(T var1) throws IOException;
}

