/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.util.JVMUtil;
import java.nio.ByteBuffer;

public final class ClientMessageReader {
    private static final int INT_MASK = 65535;
    private int readOffset = -1;
    private ClientMessage clientMessage;
    private int sumUntrustedMessageLength;
    private final int maxMessageLength;

    public ClientMessageReader(int maxMessageLenth) {
        this.maxMessageLength = maxMessageLenth > 0 ? maxMessageLenth : Integer.MAX_VALUE;
    }

    public boolean readFrom(ByteBuffer src, boolean trusted) {
        while (this.readFrame(src, trusted)) {
            if (ClientMessage.isFlagSet(this.clientMessage.endFrame.flags, 8192)) {
                return true;
            }
            this.readOffset = -1;
        }
        return false;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public void reset() {
        this.readOffset = -1;
        this.clientMessage = null;
    }

    private boolean readFrame(ByteBuffer src, boolean trusted) {
        int remaining = src.remaining();
        if (remaining < 6) {
            return false;
        }
        if (this.readOffset == -1) {
            int frameLength = Bits.readIntL(src, src.position());
            if (frameLength < 6) {
                throw new IllegalArgumentException(String.format("The client message frame reported illegal length (%d bytes). Minimal length is the size of frame header (%d bytes).", frameLength, 6));
            }
            if (!trusted) {
                if (Integer.MAX_VALUE - frameLength < this.sumUntrustedMessageLength || this.sumUntrustedMessageLength + frameLength > this.maxMessageLength) {
                    throw new MaxMessageSizeExceeded(String.format("The client message size (%d + %d) exceededs the maximum allowed length (%d)", this.sumUntrustedMessageLength, frameLength, this.maxMessageLength));
                }
                this.sumUntrustedMessageLength += frameLength;
            }
            JVMUtil.upcast(src).position(src.position() + 4);
            int flags = Bits.readShortL(src, src.position()) & 0xFFFF;
            JVMUtil.upcast(src).position(src.position() + 2);
            int size2 = frameLength - 6;
            byte[] bytes = new byte[size2];
            ClientMessage.Frame frame = new ClientMessage.Frame(bytes, flags);
            if (this.clientMessage == null) {
                this.clientMessage = ClientMessage.createForDecode(frame);
            } else {
                this.clientMessage.add(frame);
            }
            this.readOffset = 0;
            if (size2 == 0) {
                return true;
            }
        }
        ClientMessage.Frame frame = this.clientMessage.endFrame;
        return this.accumulate(src, frame.content, frame.content.length - this.readOffset);
    }

    private boolean accumulate(ByteBuffer src, byte[] dest, int length) {
        int readLength;
        int remaining = src.remaining();
        int n = readLength = remaining < length ? remaining : length;
        if (readLength > 0) {
            src.get(dest, this.readOffset, readLength);
            this.readOffset += readLength;
            return readLength == length;
        }
        return false;
    }
}

