/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListUUIDLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class PNCounterAddCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1901056;
    public static final int RESPONSE_MESSAGE_TYPE = 1901057;
    private static final int REQUEST_DELTA_FIELD_OFFSET = 16;
    private static final int REQUEST_GET_BEFORE_UPDATE_FIELD_OFFSET = 24;
    private static final int REQUEST_TARGET_REPLICA_UUID_FIELD_OFFSET = 25;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 42;
    private static final int RESPONSE_VALUE_FIELD_OFFSET = 13;
    private static final int RESPONSE_REPLICA_COUNT_FIELD_OFFSET = 21;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 25;

    private PNCounterAddCodec() {
    }

    public static ClientMessage encodeRequest(String name, long delta, boolean getBeforeUpdate, Collection<Map.Entry<UUID, Long>> replicaTimestamps, UUID targetReplicaUUID) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("PNCounter.Add");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[42], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1901056);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, delta);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 24, getBeforeUpdate);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 25, targetReplicaUUID);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        EntryListUUIDLongCodec.encode(clientMessage, replicaTimestamps);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.delta = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.getBeforeUpdate = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 24);
        request.targetReplicaUUID = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 25);
        request.name = StringCodec.decode(iterator2);
        request.replicaTimestamps = EntryListUUIDLongCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(long value, Collection<Map.Entry<UUID, Long>> replicaTimestamps, int replicaCount) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[25], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1901057);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, value);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 21, replicaCount);
        clientMessage.add(initialFrame);
        EntryListUUIDLongCodec.encode(clientMessage, replicaTimestamps);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        response.value = FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
        response.replicaCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 21);
        response.replicaTimestamps = EntryListUUIDLongCodec.decode(iterator2);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long value;
        public List<Map.Entry<UUID, Long>> replicaTimestamps;
        public int replicaCount;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public long delta;
        public boolean getBeforeUpdate;
        public List<Map.Entry<UUID, Long>> replicaTimestamps;
        public UUID targetReplicaUUID;
    }
}

