/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class ScheduledExecutorGetStatsFromMemberCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1705472;
    public static final int RESPONSE_MESSAGE_TYPE = 1705473;
    private static final int REQUEST_MEMBER_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 33;
    private static final int RESPONSE_LAST_IDLE_TIME_NANOS_FIELD_OFFSET = 13;
    private static final int RESPONSE_TOTAL_IDLE_TIME_NANOS_FIELD_OFFSET = 21;
    private static final int RESPONSE_TOTAL_RUNS_FIELD_OFFSET = 29;
    private static final int RESPONSE_TOTAL_RUN_TIME_NANOS_FIELD_OFFSET = 37;
    private static final int RESPONSE_LAST_RUN_DURATION_NANOS_FIELD_OFFSET = 45;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 53;

    private ScheduledExecutorGetStatsFromMemberCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName, String taskName, UUID memberUuid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ScheduledExecutor.GetStatsFromMember");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1705472);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, memberUuid);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        StringCodec.encode(clientMessage, taskName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.memberUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.schedulerName = StringCodec.decode(iterator2);
        request.taskName = StringCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(long lastIdleTimeNanos, long totalIdleTimeNanos, long totalRuns, long totalRunTimeNanos, long lastRunDurationNanos) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[53], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1705473);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, lastIdleTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 21, totalIdleTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 29, totalRuns);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 37, totalRunTimeNanos);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 45, lastRunDurationNanos);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        response.lastIdleTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
        response.totalIdleTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 21);
        response.totalRuns = FixedSizeTypesCodec.decodeLong(initialFrame.content, 29);
        response.totalRunTimeNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 37);
        response.lastRunDurationNanos = FixedSizeTypesCodec.decodeLong(initialFrame.content, 45);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long lastIdleTimeNanos;
        public long totalIdleTimeNanos;
        public long totalRuns;
        public long totalRunTimeNanos;
        public long lastRunDurationNanos;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
        public String taskName;
        public UUID memberUuid;
    }
}

