/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.instance.EndpointQualifier;

public final class EndpointQualifierCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private EndpointQualifierCodec() {
    }

    public static void encode(ClientMessage clientMessage, EndpointQualifier endpointQualifier) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, endpointQualifier.getType());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, endpointQualifier.getIdentifier(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static EndpointQualifier decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String identifier = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createEndpointQualifier(type, identifier);
    }
}

