/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.util;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.ClientMessageWriter;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.JVMUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public class ClientMessageEncoder
extends OutboundHandler<Supplier<ClientMessage>, ByteBuffer> {
    private ClientMessage message;
    private final ClientMessageWriter clientMessageWriter = new ClientMessageWriter();

    @Override
    public void handlerAdded() {
        this.initDstBuffer();
    }

    @Override
    public HandlerStatus onWrite() {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            while (true) {
                if (this.message == null) {
                    this.message = (ClientMessage)((Supplier)this.src).get();
                    if (this.message == null) {
                        HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                        return handlerStatus;
                    }
                }
                if (!this.clientMessageWriter.writeTo((ByteBuffer)this.dst, this.message)) break;
                this.message = null;
            }
            HandlerStatus handlerStatus = HandlerStatus.DIRTY;
            return handlerStatus;
        }
        finally {
            JVMUtil.upcast((Buffer)this.dst).flip();
        }
    }
}

