/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.core.JsonGenerator;
import com.hazelcast.com.fasterxml.jackson.core.TreeCodec;
import com.hazelcast.com.fasterxml.jackson.core.TreeNode;
import com.hazelcast.com.fasterxml.jackson.core.io.SerializedString;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.hazelcast.com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.BeanPropertyWriter;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.ValueWriterLocator;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JSONWriter {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final TreeCodec _treeCodec;
    protected final ValueWriterLocator _writerLocator;
    protected final JsonGenerator _generator;
    protected final TimeZone _timezone;
    protected final int _features;
    protected final boolean _writeNullValues;

    public JSONWriter() {
        this._features = 0;
        this._writeNullValues = false;
        this._writerLocator = null;
        this._treeCodec = null;
        this._generator = null;
        this._timezone = DEFAULT_TIMEZONE;
    }

    protected JSONWriter(JSONWriter jSONWriter, int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        this._features = n;
        this._writeNullValues = JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(n);
        this._treeCodec = treeCodec;
        this._writerLocator = valueWriterLocator.perOperationInstance(this, n);
        this._generator = jsonGenerator;
        this._timezone = DEFAULT_TIMEZONE;
    }

    public JSONWriter withCacheCheck(int n) {
        return this;
    }

    public JSONWriter perOperationInstance(int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        if (this.getClass() != JSONWriter.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONWriter(this, n, valueWriterLocator, treeCodec, jsonGenerator);
    }

    public boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public void writeValue(Object object) throws IOException {
        if (object == null) {
            this.writeNullValue();
            return;
        }
        this._writeValue(object, this._writerLocator.findSerializationType(object.getClass()));
    }

    public void writeField(String string2, Object object, int n) throws IOException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                this.writeMapField(string2, (Map)object);
                return;
            }
            case 2: {
                this.writeListField(string2, (List)object);
                return;
            }
            case 3: {
                this.writeCollectionField(string2, (Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayField(string2, (Object[])object);
                return;
            }
            case 5: {
                this.writeIntArrayField(string2, (int[])object);
                return;
            }
            case 6: {
                this.writeLongArrayField(string2, (long[])object);
                return;
            }
            case 7: {
                this.writeBooleanArrayField(string2, (boolean[])object);
                return;
            }
            case 8: {
                this.writeTreeNodeField(string2, (TreeNode)object);
                return;
            }
            case 9: {
                this.writeStringField(string2, (String)object);
                return;
            }
            case 11: {
                this.writeStringField(string2, new String((char[])object));
                return;
            }
            case 10: {
                this.writeStringField(string2, ((CharSequence)object).toString());
                return;
            }
            case 12: {
                this.writeBinaryField(string2, (byte[])object);
                return;
            }
            case 20: {
                this.writeBigDecimalField(string2, (BigDecimal)object);
                return;
            }
            case 19: {
                this.writeBigIntegerField(string2, (BigInteger)object);
                return;
            }
            case 17: 
            case 18: {
                this.writeDoubleField(string2, ((Number)object).doubleValue());
                return;
            }
            case 13: 
            case 14: 
            case 15: {
                this.writeIntField(string2, ((Number)object).intValue());
                return;
            }
            case 16: {
                this.writeLongField(string2, ((Number)object).longValue());
                return;
            }
            case 21: {
                this.writeBooleanField(string2, (Boolean)object);
                return;
            }
            case 22: {
                this.writeStringField(string2, String.valueOf(object));
                return;
            }
            case 25: {
                this.writeDateField(string2, ((Calendar)object).getTime());
                return;
            }
            case 24: {
                this.writeDateField(string2, (Date)object);
                return;
            }
            case 23: {
                this.writeEnumField(string2, (Enum)object);
                return;
            }
            case 26: {
                this.writeStringLikeField(string2, ((Class)object).getName(), n);
                return;
            }
            case 27: {
                this.writeStringLikeField(string2, ((File)object).getAbsolutePath(), n);
                return;
            }
            case 28: 
            case 29: 
            case 30: {
                this.writeStringLikeField(string2, object.toString(), n);
                return;
            }
            case 31: {
                this.writeIterableField(string2, (Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownField(string2, object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            this._generator.writeFieldName(string2);
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void _writeValue(Object object, int n) throws IOException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                this.writeMapValue((Map)object);
                return;
            }
            case 2: {
                this.writeListValue((List)object);
                return;
            }
            case 3: {
                this.writeCollectionValue((Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayValue((Object[])object);
                return;
            }
            case 5: {
                this.writeIntArrayValue((int[])object);
                return;
            }
            case 6: {
                this.writeLongArrayValue((long[])object);
                return;
            }
            case 7: {
                this.writeBooleanArrayValue((boolean[])object);
                return;
            }
            case 8: {
                this.writeTreeNodeValue((TreeNode)object);
                return;
            }
            case 9: {
                this.writeStringValue((String)object);
                return;
            }
            case 11: {
                this.writeStringValue(new String((char[])object));
                return;
            }
            case 10: {
                this.writeStringValue(((CharSequence)object).toString());
                return;
            }
            case 12: {
                this.writeBinaryValue((byte[])object);
                return;
            }
            case 17: 
            case 18: {
                this.writeDoubleValue(((Number)object).doubleValue());
                return;
            }
            case 13: 
            case 14: 
            case 15: {
                this.writeIntValue(((Number)object).intValue());
                return;
            }
            case 16: {
                this.writeLongValue(((Number)object).longValue());
                return;
            }
            case 20: {
                this.writeBigDecimalValue((BigDecimal)object);
                return;
            }
            case 19: {
                this.writeBigIntegerValue((BigInteger)object);
                return;
            }
            case 21: {
                this.writeBooleanValue((Boolean)object);
                return;
            }
            case 22: {
                this.writeStringValue(String.valueOf(object));
                return;
            }
            case 25: {
                this.writeDateValue(((Calendar)object).getTime());
                return;
            }
            case 24: {
                this.writeDateValue((Date)object);
                return;
            }
            case 23: {
                this.writeEnumValue((Enum)object);
                return;
            }
            case 26: {
                this.writeStringLikeValue(((Class)object).getName(), n);
                return;
            }
            case 27: {
                this.writeStringLikeValue(((File)object).getAbsolutePath(), n);
                return;
            }
            case 28: 
            case 29: 
            case 30: {
                this.writeStringLikeValue(object.toString(), n);
                return;
            }
            case 31: {
                this.writeIterableValue((Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownValue(object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void writeCollectionValue(Collection<?> collection) throws IOException {
        this._generator.writeStartArray();
        for (Object obj : collection) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeCollectionField(String string2, Collection<?> collection) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeCollectionValue(collection);
    }

    protected void writeIterableValue(Iterable<?> iterable) throws IOException {
        this._generator.writeStartArray();
        for (Object obj : iterable) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeIterableField(String string2, Iterable<?> iterable) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeIterableValue(iterable);
    }

    protected void writeListValue(List<?> list) throws IOException {
        this._generator.writeStartArray();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj == null) {
                this._generator.writeNull();
                continue;
            }
            this._writeValue(obj, this._writerLocator.findSerializationType(obj.getClass()));
        }
        this._generator.writeEndArray();
    }

    protected void writeListField(String string2, List<?> list) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeListValue(list);
    }

    protected void writeMapValue(Map<?, ?> map2) throws IOException {
        this._generator.writeStartObject();
        if (!map2.isEmpty()) {
            for (Map.Entry<?, ?> entry : map2.entrySet()) {
                String string2 = this.keyToString(entry.getKey());
                Object obj = entry.getValue();
                if (obj == null) {
                    if (!this._writeNullValues) continue;
                    this.writeNullField(string2);
                    continue;
                }
                Class<?> clazz = obj.getClass();
                int n = this._writerLocator.findSerializationType(clazz);
                this.writeField(string2, obj, n);
            }
        }
        this._generator.writeEndObject();
    }

    protected void writeMapField(String string2, Map<?, ?> map2) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeMapValue(map2);
    }

    protected void writeObjectArrayValue(Object[] objectArray) throws IOException {
        this._generator.writeStartArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.writeValue(objectArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeObjectArrayField(String string2, Object[] objectArray) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeObjectArrayValue(objectArray);
    }

    protected void writeIntArrayValue(int[] nArray) throws IOException {
        this._generator.writeStartArray();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(nArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeIntArrayField(String string2, int[] nArray) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeIntArrayValue(nArray);
    }

    protected void writeLongArrayValue(long[] lArray) throws IOException {
        this._generator.writeStartArray();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(lArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeLongArrayField(String string2, long[] lArray) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeLongArrayValue(lArray);
    }

    protected void writeBooleanArrayValue(boolean[] blArray) throws IOException {
        this._generator.writeStartArray();
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeBoolean(blArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeBooleanArrayField(String string2, boolean[] blArray) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeBooleanArrayValue(blArray);
    }

    protected void writeTreeNodeValue(TreeNode treeNode) throws IOException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No `TreeCodec` configured: can not serialize `TreeNode` values");
        }
        this._treeCodec.writeTree(this._generator, treeNode);
    }

    protected void writeTreeNodeField(String string2, TreeNode treeNode) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeTreeNodeValue(treeNode);
    }

    protected void writeBooleanValue(boolean bl) throws IOException {
        this._generator.writeBoolean(bl);
    }

    protected void writeBooleanField(String string2, boolean bl) throws IOException {
        this._generator.writeBooleanField(string2, bl);
    }

    protected void writeIntValue(int n) throws IOException {
        this._generator.writeNumber(n);
    }

    protected void writeIntField(String string2, int n) throws IOException {
        this._generator.writeNumberField(string2, n);
    }

    protected void writeLongValue(long l) throws IOException {
        this._generator.writeNumber(l);
    }

    protected void writeBigIntegerValue(BigInteger bigInteger) throws IOException {
        this._generator.writeNumber(bigInteger);
    }

    protected void writeBigIntegerField(String string2, BigInteger bigInteger) throws IOException {
        this._generator.writeFieldName(string2);
        this.writeBigIntegerValue(bigInteger);
    }

    protected void writeLongField(String string2, long l) throws IOException {
        this._generator.writeNumberField(string2, l);
    }

    protected void writeDoubleValue(double d) throws IOException {
        this._generator.writeNumber(d);
    }

    protected void writeDoubleField(String string2, double d) throws IOException {
        this._generator.writeNumberField(string2, d);
    }

    protected void writeBigDecimalValue(BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumber(bigDecimal);
    }

    protected void writeBigDecimalField(String string2, BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumberField(string2, bigDecimal);
    }

    protected void writeStringValue(String string2) throws IOException {
        this._generator.writeString(string2);
    }

    protected void writeStringField(String string2, String string3) throws IOException {
        this._generator.writeStringField(string2, string3);
    }

    protected void writeStringLikeValue(String string2, int n) throws IOException {
        this._generator.writeString(string2);
    }

    protected void writeStringLikeField(String string2, String string3, int n) throws IOException {
        this._generator.writeStringField(string2, string3);
    }

    protected void writeBinaryValue(byte[] byArray) throws IOException {
        this._generator.writeBinary(byArray);
    }

    protected void writeBinaryField(String string2, byte[] byArray) throws IOException {
        this._generator.writeBinaryField(string2, byArray);
    }

    protected void writeNullValue() throws IOException {
        this._generator.writeNull();
    }

    protected void writeNullField(String string2) throws IOException {
        if (this._writeNullValues) {
            this._generator.writeNullField(string2);
        }
    }

    protected void writeNullField(SerializedString serializedString) throws IOException {
        if (this._writeNullValues) {
            this._generator.writeFieldName(serializedString);
            this._generator.writeNull();
        }
    }

    protected void writeDateValue(Date date) throws IOException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongValue(date.getTime());
        } else {
            this.writeStringValue(this.dateToString(date));
        }
    }

    protected void writeDateField(String string2, Date date) throws IOException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongField(string2, date.getTime());
        } else {
            this.writeStringField(string2, this.dateToString(date));
        }
    }

    protected void writeEnumValue(Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntValue(enum_.ordinal());
        } else {
            this.writeStringValue(enum_.toString());
        }
    }

    protected void writeEnumField(String string2, Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntField(string2, enum_.ordinal());
        } else {
            this.writeStringField(string2, enum_.toString());
        }
    }

    public void writeBeanValue(BeanPropertyWriter[] beanPropertyWriterArray, Object object) throws IOException {
        this._generator.writeStartObject();
        for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
            SerializedString serializedString = beanPropertyWriter.name;
            Object object2 = beanPropertyWriter.getValueFor(object);
            if (object2 == null) {
                if (!this._writeNullValues) continue;
                this.writeNullField(serializedString);
                continue;
            }
            int n = beanPropertyWriter.typeId;
            if (n == 0) {
                n = this._writerLocator.findSerializationType(object2.getClass());
            }
            this._generator.writeFieldName(serializedString);
            this._writeValue(object2, n);
        }
        this._generator.writeEndObject();
    }

    protected void writeUnknownValue(Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringValue(object.toString());
    }

    protected void writeUnknownField(String string2, Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringField(string2, object.toString());
    }

    protected void _checkUnknown(Object object) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE.isEnabled(this._features)) {
            throw new JSONObjectException("Unrecognized type (" + object.getClass().getName() + "), don't know how to write (disable " + (Object)((Object)JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE) + " to avoid exception)");
        }
    }

    protected String keyToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    protected String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return date.toString();
    }

    private void _badType(int n, Object object) {
        if (n < 0) {
            throw new IllegalStateException(String.format("Internal error: missing BeanDefinition for id %d (class %s)", n, object.getClass().getName()));
        }
        throw new IllegalStateException(String.format("Unsupported type: %s (%s)", n, object.getClass().getName()));
    }
}

