/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.countdownlatch;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.countdownlatch.AwaitInvocationKey;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatch;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.spi.blocking.ResourceRegistry;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public class CountDownLatchRegistry
extends ResourceRegistry<AwaitInvocationKey, CountDownLatch>
implements IdentifiedDataSerializable {
    CountDownLatchRegistry() {
    }

    CountDownLatchRegistry(CPGroupId groupId) {
        super(groupId);
    }

    @Override
    protected CountDownLatch createNewResource(CPGroupId groupId, String name) {
        return new CountDownLatch(groupId, name);
    }

    protected CountDownLatchRegistry cloneForSnapshot() {
        CountDownLatchRegistry clone2 = new CountDownLatchRegistry();
        clone2.groupId = this.groupId;
        for (Map.Entry e : this.resources.entrySet()) {
            clone2.resources.put(e.getKey(), ((CountDownLatch)e.getValue()).cloneForSnapshot());
        }
        clone2.destroyedNames.addAll(this.destroyedNames);
        clone2.waitTimeouts.putAll(this.waitTimeouts);
        return clone2;
    }

    boolean trySetCount(String name, int count2) {
        return ((CountDownLatch)this.getOrInitResource(name)).trySetCount(count2);
    }

    BiTuple<Integer, Collection<AwaitInvocationKey>> countDown(String name, UUID invocationUuid, int expectedRound) {
        CountDownLatch latch = (CountDownLatch)this.getOrInitResource(name);
        BiTuple<Integer, Collection<AwaitInvocationKey>> t = latch.countDown(invocationUuid, expectedRound);
        for (AwaitInvocationKey key : (Collection)t.element2) {
            this.removeWaitKey(name, key);
        }
        return t;
    }

    boolean await(String name, AwaitInvocationKey key, long timeoutMs) {
        boolean success = ((CountDownLatch)this.getOrInitResource(name)).await(key, timeoutMs > 0L);
        if (!success) {
            this.addWaitKey(name, key, timeoutMs);
        }
        return success;
    }

    int getRemainingCount(String name) {
        return ((CountDownLatch)this.getOrInitResource(name)).getRemainingCount();
    }

    int getRound(String name) {
        return ((CountDownLatch)this.getOrInitResource(name)).getRound();
    }

    Collection<CountDownLatch> getAllLatches() {
        return this.resources.values();
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

