/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.Pipe;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.BroadcastItem;
import com.hazelcast.jet.impl.execution.DoneItem;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.SnapshotBarrier;
import com.hazelcast.jet.impl.execution.WatermarkCoalescer;
import com.hazelcast.jet.impl.util.PrefixedLogger;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConcurrentInboundEdgeStream {
    private ConcurrentInboundEdgeStream() {
    }

    public static InboundEdgeStream create(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, boolean waitForAllBarriers, @Nonnull String debugName, @Nullable ComparatorEx<?> comparator) {
        if (comparator == null) {
            return new RoundRobinDrain(conveyor, ordinal, priority, debugName, waitForAllBarriers);
        }
        return new OrderedDrain(conveyor, ordinal, priority, debugName, comparator);
    }

    private static final class OrderedDrain
    extends InboundEdgeStreamBase {
        private final Comparator<Object> comparator;
        private final List<QueuedPipe<Object>> queues;
        private final List<ArrayDeque<Object>> drainedItems;
        private Object lastItem;
        private int lastMinIndex;

        OrderedDrain(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName, @Nullable ComparatorEx<?> comparator) {
            super(conveyor, ordinal, priority, debugName);
            this.comparator = comparator;
            this.drainedItems = new ArrayList<ArrayDeque<Object>>(conveyor.queueCount());
            this.queues = new ArrayList<QueuedPipe<Object>>(conveyor.queueCount());
            for (int i = 0; i < conveyor.queueCount(); ++i) {
                QueuedPipe<Object> q = conveyor.queue(i);
                this.drainedItems.add(new ArrayDeque(q.capacity()));
                this.queues.add(q);
            }
        }

        @Override
        @Nonnull
        public ProgressState drainTo(@Nonnull Predicate<Object> dest) {
            this.tracker.reset();
            this.tracker.notDone();
            for (int i = 0; i < this.queues.size(); ++i) {
                if (!this.drainedItems.get(i).isEmpty()) continue;
                this.queues.get(i).drainTo((Collection<Object>)this.drainedItems.get(i), Integer.MAX_VALUE);
            }
            block1: while (true) {
                Object minItem = null;
                for (int i = 0; i < this.drainedItems.size(); ++i) {
                    Object item = this.drainedItems.get(i).peek();
                    if (item == null) {
                        return this.tracker.toProgressState();
                    }
                    this.tracker.madeProgress();
                    if (item == DoneItem.DONE_ITEM) {
                        this.queues.remove(i);
                        this.drainedItems.remove(i);
                        if (!this.queues.isEmpty()) continue block1;
                        this.tracker.done();
                        return this.tracker.toProgressState();
                    }
                    if (item instanceof Watermark || item instanceof SnapshotBarrier) {
                        throw new JetException("Unexpected item observed: " + item);
                    }
                    if (minItem != null && this.comparator.compare(minItem, item) <= 0) continue;
                    minItem = item;
                    this.lastMinIndex = i;
                }
                this.drainedItems.get(this.lastMinIndex).remove();
                assert (this.lastItem == null || this.comparator.compare(this.lastItem, minItem) <= 0) : "Disorder on a monotonicOrder edge";
                this.lastItem = minItem;
                boolean consumeResult = dest.test(this.lastItem);
                if (!$assertionsDisabled && !consumeResult) break;
            }
            throw new AssertionError((Object)"consumeResult is false");
        }

        @Override
        public long topObservedWm() {
            return Long.MIN_VALUE;
        }

        @Override
        public long coalescedWm() {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean isDone() {
            return this.queues.isEmpty();
        }
    }

    private static final class RoundRobinDrain
    extends InboundEdgeStreamBase {
        private final ItemDetector itemDetector = new ItemDetector();
        private final WatermarkCoalescer watermarkCoalescer;
        private final BitSet receivedBarriers;
        private boolean waitForAllBarriers;
        private SnapshotBarrier currentBarrier;

        RoundRobinDrain(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName, boolean waitForAllBarriers) {
            super(conveyor, ordinal, priority, debugName);
            this.waitForAllBarriers = waitForAllBarriers;
            this.watermarkCoalescer = WatermarkCoalescer.create(conveyor.queueCount());
            this.receivedBarriers = new BitSet(conveyor.queueCount());
        }

        @Override
        @Nonnull
        public ProgressState drainTo(@Nonnull Predicate<Object> dest) {
            this.tracker.reset();
            for (int queueIndex = 0; queueIndex < this.conveyor.queueCount(); ++queueIndex) {
                QueuedPipe<Object> q = this.conveyor.queue(queueIndex);
                if (q == null || this.waitForAllBarriers && this.receivedBarriers.get(queueIndex)) continue;
                ProgressState result2 = this.drainQueue(q, dest);
                this.tracker.mergeWith(result2);
                if (this.itemDetector.item == DoneItem.DONE_ITEM) {
                    this.conveyor.removeQueue(queueIndex);
                    this.receivedBarriers.clear(queueIndex);
                    long wmTimestamp = this.watermarkCoalescer.queueDone(queueIndex);
                    if (this.maybeEmitWm(wmTimestamp, dest)) {
                        if (this.logger.isFinestEnabled()) {
                            this.logger.finest("Queue " + queueIndex + " is done, forwarding " + new Watermark(wmTimestamp));
                        }
                        return this.conveyor.liveQueueCount() == 0 ? ProgressState.DONE : ProgressState.MADE_PROGRESS;
                    }
                } else if (this.itemDetector.item instanceof Watermark) {
                    long wmTimestamp = ((Watermark)this.itemDetector.item).timestamp();
                    boolean forwarded = this.maybeEmitWm(this.watermarkCoalescer.observeWm(queueIndex, wmTimestamp), dest);
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Received " + this.itemDetector.item + " from queue " + queueIndex + (forwarded ? ", forwarded=" : ", not forwarded") + ", coalescedWm=" + Util.toLocalTime(this.watermarkCoalescer.coalescedWm()) + ", topObservedWm=" + Util.toLocalTime(this.topObservedWm()));
                    }
                    if (forwarded) {
                        return ProgressState.MADE_PROGRESS;
                    }
                } else if (this.itemDetector.item instanceof SnapshotBarrier) {
                    this.observeBarrier(queueIndex, (SnapshotBarrier)this.itemDetector.item);
                } else if (result2.isMadeProgress()) {
                    this.watermarkCoalescer.observeEvent(queueIndex);
                }
                int liveQueueCount = this.conveyor.liveQueueCount();
                if (liveQueueCount == 0) {
                    return this.tracker.toProgressState();
                }
                if (this.itemDetector.item == null || this.receivedBarriers.cardinality() != liveQueueCount) continue;
                assert (this.currentBarrier != null) : "currentBarrier == null";
                boolean res = dest.test(this.currentBarrier);
                assert (res) : "test result expected to be true";
                this.currentBarrier = null;
                this.receivedBarriers.clear();
                return ProgressState.MADE_PROGRESS;
            }
            if (this.maybeEmitWm(this.watermarkCoalescer.checkWmHistory(), dest)) {
                return ProgressState.MADE_PROGRESS;
            }
            if (this.conveyor.liveQueueCount() > 0) {
                this.tracker.notDone();
            }
            return this.tracker.toProgressState();
        }

        private ProgressState drainQueue(Pipe<Object> queue, Predicate<Object> dest) {
            this.itemDetector.reset(dest);
            int drainedCount = queue.drain(this.itemDetector);
            this.itemDetector.dest = null;
            return ProgressState.valueOf(drainedCount > 0, this.itemDetector.item == DoneItem.DONE_ITEM);
        }

        private void observeBarrier(int queueIndex, SnapshotBarrier barrier) {
            if (this.currentBarrier == null) {
                this.currentBarrier = barrier;
            } else assert (this.currentBarrier.equals(barrier)) : this.currentBarrier + " != " + barrier;
            if (barrier.isTerminal()) {
                this.waitForAllBarriers = true;
            }
            this.receivedBarriers.set(queueIndex);
        }

        private boolean maybeEmitWm(long timestamp, Predicate<Object> dest) {
            if (timestamp != Long.MIN_VALUE) {
                boolean res = dest.test(new Watermark(timestamp));
                assert (res) : "test result expected to be true";
                return true;
            }
            return false;
        }

        @Override
        public long topObservedWm() {
            return this.watermarkCoalescer.topObservedWm();
        }

        @Override
        public long coalescedWm() {
            return this.watermarkCoalescer.coalescedWm();
        }

        private static final class ItemDetector
        implements Predicate<Object> {
            Predicate<Object> dest;
            BroadcastItem item;

            private ItemDetector() {
            }

            void reset(Predicate<Object> newDest) {
                this.dest = newDest;
                this.item = null;
            }

            @Override
            public boolean test(Object o) {
                if (o instanceof Watermark || o instanceof SnapshotBarrier || o == DoneItem.DONE_ITEM) {
                    assert (this.item == null) : "Received multiple special items without a call to reset(): " + this.item;
                    this.item = (BroadcastItem)o;
                    return false;
                }
                return this.dest.test(o);
            }
        }
    }

    private static abstract class InboundEdgeStreamBase
    implements InboundEdgeStream {
        final ProgressTracker tracker = new ProgressTracker();
        final ConcurrentConveyor<Object> conveyor;
        final int ordinal;
        final int priority;
        final ILogger logger;

        private InboundEdgeStreamBase(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName) {
            this.conveyor = conveyor;
            this.ordinal = ordinal;
            this.priority = priority;
            this.logger = PrefixedLogger.prefixedLogger(Logger.getLogger(this.getClass()), debugName);
            this.logger.finest("Coalescing " + conveyor.queueCount() + " input queues");
        }

        @Override
        public int ordinal() {
            return this.ordinal;
        }

        @Override
        public int priority() {
            return this.priority;
        }

        @Override
        public boolean isDone() {
            return this.conveyor.liveQueueCount() == 0;
        }

        @Override
        public int sizes() {
            return this.conveyorSum(Collection::size);
        }

        @Override
        public int capacities() {
            return this.conveyorSum(Pipe::capacity);
        }

        private int conveyorSum(ToIntFunction<QueuedPipe<Object>> toIntF) {
            int sum2 = 0;
            for (int queueIndex = 0; queueIndex < this.conveyor.queueCount(); ++queueIndex) {
                QueuedPipe<Object> q = this.conveyor.queue(queueIndex);
                if (q == null) continue;
                sum2 += toIntF.applyAsInt(q);
            }
            return sum2;
        }
    }
}

