/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.list.AbstractSerializableListDecorator;

public class GrowthList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = -3620001881672L;

    public static <E> GrowthList<E> growthList(List<E> list) {
        return new GrowthList<E>(list);
    }

    public GrowthList() {
        super(new ArrayList());
    }

    public GrowthList(int initialSize) {
        super(new ArrayList(initialSize));
    }

    protected GrowthList(List<E> list) {
        super(list);
    }

    @Override
    public void add(int index, E element) {
        int size2 = this.decorated().size();
        if (index > size2) {
            this.decorated().addAll(Collections.nCopies(index - size2, null));
        }
        this.decorated().add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        int size2 = this.decorated().size();
        boolean result2 = false;
        if (index > size2) {
            this.decorated().addAll(Collections.nCopies(index - size2, null));
            result2 = true;
        }
        return this.decorated().addAll(index, coll) || result2;
    }

    @Override
    public E set(int index, E element) {
        int size2 = this.decorated().size();
        if (index >= size2) {
            this.decorated().addAll(Collections.nCopies(index - size2 + 1, null));
        }
        return this.decorated().set(index, element);
    }
}

