/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.bridge;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.bridge.FilterAdapter;
import org.apache.log4j.bridge.LogEventAdapter;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.CompositeFilter;

public class AppenderAdapter {
    private final Appender appender;
    private final Adapter adapter;

    public AppenderAdapter(Appender appender) {
        this.appender = appender;
        AbstractLifeCycle appenderFilter = null;
        if (appender.getFilter() != null) {
            if (appender.getFilter().getNext() != null) {
                ArrayList<FilterAdapter> filters = new ArrayList<FilterAdapter>();
                for (org.apache.log4j.spi.Filter filter2 = appender.getFilter(); filter2 != null; filter2 = filter2.getNext()) {
                    filters.add(new FilterAdapter(filter2));
                }
                appenderFilter = CompositeFilter.createFilters(filters.toArray(Filter.EMPTY_ARRAY));
            } else {
                appenderFilter = new FilterAdapter(appender.getFilter());
            }
        }
        this.adapter = new Adapter(appender.getName(), (Filter)((Object)appenderFilter), null, true, null);
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public class Adapter
    extends AbstractAppender {
        protected Adapter(String name, Filter filter2, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
            super(name, filter2, layout, ignoreExceptions, properties);
        }

        @Override
        public void append(LogEvent event) {
            AppenderAdapter.this.appender.doAppend(new LogEventAdapter(event));
        }

        @Override
        public void stop() {
            AppenderAdapter.this.appender.close();
        }

        public Appender getAppender() {
            return AppenderAdapter.this.appender;
        }
    }
}

