/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.Arrays;

public final class RawJobMetrics
implements Serializable {
    private long timestamp;
    private byte[] blob;

    RawJobMetrics() {
    }

    private RawJobMetrics(long timestamp, byte[] blob) {
        this.timestamp = timestamp;
        this.blob = blob;
    }

    public static RawJobMetrics empty() {
        return RawJobMetrics.of(null);
    }

    public static RawJobMetrics of(byte[] blob) {
        return new RawJobMetrics(System.currentTimeMillis(), blob);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public int hashCode() {
        return (int)this.timestamp * 31 + Arrays.hashCode(this.blob);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RawJobMetrics that = (RawJobMetrics)obj;
        return Arrays.equals(this.blob, that.blob) && this.timestamp == that.timestamp;
    }

    public String toString() {
        return Arrays.toString(this.blob) + " @ " + this.timestamp;
    }
}

