/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.api.table.type.CompositeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class SeaTunnelRowType
implements CompositeType<SeaTunnelRow> {
    private static final long serialVersionUID = 2L;
    private final String[] fieldNames;
    private final SeaTunnelDataType<?>[] fieldTypes;

    public SeaTunnelRowType(String[] fieldNames, SeaTunnelDataType<?>[] fieldTypes) {
        Preconditions.checkArgument(fieldNames.length == fieldTypes.length, "The number of field names must be the same as the number of field types.");
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
    }

    @Override
    public Class<SeaTunnelRow> getTypeClass() {
        return SeaTunnelRow.class;
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.ROW;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public SeaTunnelDataType<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public List<SeaTunnelDataType<?>> getChildren() {
        return Arrays.asList(this.fieldTypes);
    }

    public int getTotalFields() {
        return this.fieldTypes.length;
    }

    public String getFieldName(int index) {
        return this.fieldNames[index];
    }

    public SeaTunnelDataType<?> getFieldType(int index) {
        return this.fieldTypes[index];
    }

    public int indexOf(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("can't find field [%s]", fieldName));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SeaTunnelRowType)) {
            return false;
        }
        SeaTunnelRowType that = (SeaTunnelRowType)obj;
        return Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldTypes, that.fieldTypes);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.fieldNames);
        result2 = 31 * result2 + Arrays.hashCode(this.fieldTypes);
        return result2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ROW<");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.fieldNames[i]).append(" ").append(this.fieldTypes[i]);
        }
        return builder.append(">").toString();
    }
}

