/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import org.apache.seatunnel.api.common.metrics.AbstractMetricsContext;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.Unit;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelMetricsContext
extends AbstractMetricsContext
implements DynamicMetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelMetricsContext.class);

    @Override
    public void provideDynamicMetrics(MetricDescriptor tagger, MetricsCollectionContext context) {
        this.metrics.forEach((name, metric) -> {
            if (metric instanceof Counter) {
                context.collect(tagger.copy(), (String)name, ProbeLevel.INFO, this.toProbeUnit(metric.unit()), ((Counter)metric).getCount());
            } else if (metric instanceof Meter) {
                context.collect(tagger.copy(), (String)name, ProbeLevel.INFO, this.toProbeUnit(metric.unit()), ((Meter)metric).getRate());
            } else {
                throw new SeaTunnelException("The value of Metric does not support " + metric.getClass().getSimpleName() + " data type");
            }
        });
    }

    private ProbeUnit toProbeUnit(Unit unit) {
        return ProbeUnit.valueOf(unit.name());
    }
}

