/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelRowTypeEditor
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelRowTypeEditor.class);
    private final LinkedList<Field> fields;

    public SeaTunnelRowTypeEditor(SeaTunnelRowType rowType) {
        log.info("Input row type: {}", (Object)rowType);
        this.fields = IntStream.range(0, rowType.getTotalFields()).boxed().map(index -> new Field(rowType.getFieldName(index.intValue()), rowType.getFieldType(index.intValue()))).collect(Collectors.toCollection(LinkedList::new));
    }

    public SeaTunnelRowTypeEditor remove(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            int index = this.fields.indexOf(Field.name(fieldName));
            this.fields.remove(index);
        }
        return this;
    }

    public SeaTunnelRowTypeEditor addLast(String fieldName, SeaTunnelDataType dataType) {
        this.fields.addLast(new Field(fieldName, dataType));
        return this;
    }

    public SeaTunnelRowTypeEditor addFirst(String fieldName, SeaTunnelDataType dataType) {
        this.fields.addFirst(new Field(fieldName, dataType));
        return this;
    }

    public SeaTunnelRowTypeEditor add(int index, String fieldName, SeaTunnelDataType dataType) {
        this.fields.add(index, new Field(fieldName, dataType));
        return this;
    }

    public SeaTunnelRowTypeEditor update(String fieldName, SeaTunnelDataType dataType) {
        int index = this.fields.indexOf(Field.name(fieldName));
        if (index == -1) {
            throw new IllegalArgumentException("");
        }
        Field field = this.fields.get(index);
        field.setDataType(dataType);
        return this;
    }

    public SeaTunnelRowTypeEditor moveBefore(String srcFieldName, String destFieldName) {
        int srcFieldIndex = this.fields.indexOf(Field.name(srcFieldName));
        int destFieldIndex = this.fields.indexOf(Field.name(destFieldName));
        Field srcField = this.fields.get(srcFieldIndex);
        this.fields.remove(srcField);
        this.fields.add(destFieldIndex, srcField);
        return this;
    }

    public SeaTunnelRowTypeEditor moveAfter(String srcFieldName, String destFieldName) {
        int srcFieldIndex = this.fields.indexOf(Field.name(srcFieldName));
        int destFieldIndex = this.fields.indexOf(Field.name(destFieldName));
        Field srcField = this.fields.get(srcFieldIndex);
        this.fields.remove(srcField);
        this.fields.add(destFieldIndex + 1, srcField);
        return this;
    }

    public SeaTunnelRowType build() {
        String[] fieldNames = new String[this.fields.size()];
        SeaTunnelDataType[] fieldDataTypes = new SeaTunnelDataType[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            fieldNames[i] = field.getName();
            fieldDataTypes[i] = field.getDataType();
        }
        SeaTunnelRowType rowType = new SeaTunnelRowType(fieldNames, fieldDataTypes);
        log.info("Output row type: {}", (Object)rowType);
        return rowType;
    }

    private static class Field
    implements Serializable {
        private String name;
        private SeaTunnelDataType dataType;

        static Field name(String name) {
            return new Field(name, null);
        }

        public Field(String name, SeaTunnelDataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "SeaTunnelRowTypeEditor.Field(name=" + this.getName() + ", dataType=" + this.getDataType() + ")";
        }

        public String getName() {
            return this.name;
        }

        public void setDataType(SeaTunnelDataType dataType) {
            this.dataType = dataType;
        }

        public SeaTunnelDataType getDataType() {
            return this.dataType;
        }
    }
}

