/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.copy;

import com.google.auto.service.AutoService;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.copy.CopyFieldTransformFactory;
import org.apache.seatunnel.transform.copy.CopyTransformConfig;

@AutoService(value={SeaTunnelTransform.class})
public class CopyFieldTransform
extends MultipleFieldOutputTransform {
    public static final String PLUGIN_NAME = "Copy";
    private CopyTransformConfig config;
    private List<String> fieldNames;
    private List<Integer> fieldOriginalIndexs;
    private List<SeaTunnelDataType> fieldTypes;

    public CopyFieldTransform(CopyTransformConfig copyTransformConfig, CatalogTable catalogTable) {
        super(catalogTable);
        this.config = copyTransformConfig;
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.initOutputFields(seaTunnelRowType, this.config.getFields());
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new CopyFieldTransformFactory().optionRule());
        this.config = CopyTransformConfig.of(ReadonlyConfig.fromConfig((Config)pluginConfig));
    }

    @Override
    protected void setInputRowType(SeaTunnelRowType inputRowType) {
        this.initOutputFields(inputRowType, this.config.getFields());
    }

    private void initOutputFields(SeaTunnelRowType inputRowType, LinkedHashMap<String, String> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Integer> fieldOriginalIndexs = new ArrayList<Integer>();
        ArrayList<SeaTunnelDataType> fieldsType = new ArrayList<SeaTunnelDataType>();
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String srcField = field.getValue();
            int srcFieldIndex = inputRowType.indexOf(srcField);
            if (srcFieldIndex == -1) {
                throw new IllegalArgumentException("Cannot find [" + srcField + "] field in input row type");
            }
            fieldNames.add(field.getKey());
            fieldOriginalIndexs.add(srcFieldIndex);
            fieldsType.add(inputRowType.getFieldType(srcFieldIndex));
        }
        this.fieldNames = fieldNames;
        this.fieldOriginalIndexs = fieldOriginalIndexs;
        this.fieldTypes = fieldsType;
    }

    @Override
    protected String[] getOutputFieldNames() {
        return this.fieldNames.toArray(new String[0]);
    }

    @Override
    protected SeaTunnelDataType[] getOutputFieldDataTypes() {
        return this.fieldTypes.toArray(new SeaTunnelDataType[0]);
    }

    @Override
    protected Column[] getOutputColumns() {
        if (this.inputCatalogTable == null) {
            Column[] columns = new Column[this.fieldNames.size()];
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                columns[i] = PhysicalColumn.of((String)this.fieldNames.get(i), (SeaTunnelDataType)this.fieldTypes.get(i), (Integer)200, (boolean)true, (Object)"", (String)"");
            }
            return columns;
        }
        Map<String, Column> catalogTableColumns = this.inputCatalogTable.getTableSchema().getColumns().stream().collect(Collectors.toMap(column -> column.getName(), column -> column));
        ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>();
        for (Map.Entry<String, String> copyField : this.config.getFields().entrySet()) {
            Column srcColumn = catalogTableColumns.get(copyField.getValue());
            PhysicalColumn destColumn = PhysicalColumn.of((String)copyField.getKey(), (SeaTunnelDataType)srcColumn.getDataType(), (Integer)srcColumn.getColumnLength(), (boolean)srcColumn.isNullable(), (Object)srcColumn.getDefaultValue(), (String)srcColumn.getComment());
            columns.add(destColumn);
        }
        return columns.toArray(new Column[0]);
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object[] fieldValues = new Object[this.fieldNames.size()];
        for (int i = 0; i < this.fieldOriginalIndexs.size(); ++i) {
            fieldValues[i] = this.clone(this.fieldTypes.get(i), inputRow.getField(this.fieldOriginalIndexs.get(i)));
        }
        return fieldValues;
    }

    private Object clone(SeaTunnelDataType dataType, Object value) {
        if (value == null) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case BOOLEAN: 
            case STRING: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return value;
            }
            case BYTES: {
                byte[] bytes = (byte[])value;
                if (bytes == null) {
                    return null;
                }
                byte[] newBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                return newBytes;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                Object[] array = (Object[])value;
                if (array == null) {
                    return null;
                }
                Object newArray = Array.newInstance(arrayType.getElementType().getTypeClass(), array.length);
                for (int i = 0; i < array.length; ++i) {
                    Array.set(newArray, i, this.clone((SeaTunnelDataType)arrayType.getElementType(), array[i]));
                }
                return newArray;
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                Map map = (Map)value;
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                for (Object key : map.keySet()) {
                    newMap.put(this.clone(mapType.getKeyType(), key), this.clone(mapType.getValueType(), map.get(key)));
                }
                return newMap;
            }
            case ROW: {
                SeaTunnelRowType rowType = (SeaTunnelRowType)dataType;
                SeaTunnelRow row = (SeaTunnelRow)value;
                if (row == null) {
                    return null;
                }
                Object[] newFields = new Object[rowType.getTotalFields()];
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    newFields[i] = this.clone(rowType.getFieldType(i), row.getField(i));
                }
                SeaTunnelRow newRow = new SeaTunnelRow(newFields);
                newRow.setRowKind(row.getRowKind());
                newRow.setTableId(row.getTableId());
                return newRow;
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType.getSqlType());
    }

    public CopyFieldTransform() {
    }
}

